% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printif.R
\name{printif}
\alias{printif}
\title{Conditionally Print an Object}
\usage{
printif(x, show = FALSE, ...)
}
\arguments{
\item{x}{Any object.}

\item{show}{A logical value indicating whether to print `x` (default: `FALSE`).}

\item{...}{Additional arguments passed to `print()`.}
}
\value{
The object `x`, printed if `show` is `TRUE`.
}
\description{
This function prints `x` if `show` is `TRUE`;
otherwise, it returns `x` unchanged.
Its main usage is to "close" dplyr-like treatment chains (using %>% or |>).
This creates an extremely handy way to process accurate line-by-line debugging,
printing results when necessary and removing the print option easily without
having to rewrite everything or take care about the last element in the chain.

This saves much code writing and debugging time.

It is also useful to design functions so that users can easily stop elements
from being printed

Given the purpose of this function, it is much more convenient to use 1 and 0
for the 'show' argument than TRUE or FALSE, as this can be switched easily
in the editor.
}
\examples{
# Basic usage
printif(42, show = TRUE)
printif(42, show = FALSE)

# Using numeric shortcuts
printif("Hello", 1)
printif("Hello", 0)

# Most useful usage : in a pipeline (requires dplyr)
if (requireNamespace("dplyr", quietly = TRUE)) {
  library(dplyr)
  mtcars \%>\%
    filter(mpg > 20) \%>\%
    summarise(mean_hp = mean(hp)) \%>\%
    printif(1)
}
}
