% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcDT.R
\name{checkDT}
\alias{checkDT}
\title{Checking if an object is a data.table object and (optional) testing if some column names are valid for it}
\usage{
checkDT(inputDT, colNamesToBeChecked = NULL)
}
\arguments{
\item{inputDT}{data.table object containing the data of interest. This is an obligatory argument, without default value.}

\item{colNamesToBeChecked}{Character vector containing potential column names of the 'inputDT' argument. The default value is NULL.}
}
\value{
No value is returned if all elements in the 'colNamesToBeChecked' argument, are valid column names of the 'inputDT' argument. In the absence of a value for the 'colNamesToBeChecked' argument, it is only tested if the 'inputDT' argument is a data.table object (is tested irrespective of the value for the 'colNamesToBeChecked' argument).
}
\description{
Checking if an object is a data.table object and (optional) testing if some column names are valid for it
}
\examples{
library(data.table)
inputDT <- as.data.table(data.frame(x = seq(1, 20, 2), y = LETTERS[1:10]))
asFactorDT(inputDT, c('y'))

checkDT(inputDT)
checkDT(inputDT, c('x', 'y'))

\donttest{checkDT(inputDT, c('x', 'y1'))
checkDT(inputDT, c('x', 'y1', 'z1'))
checkDT(inputDT, c('x1', 'y1', 'z1'))}
}
