% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_prep.r
\name{table_prep}
\alias{table_prep}
\title{Prepares the data for pivotal tabulation}
\usage{
table_prep(dfrm, x, y, var, fill = "", type = "latex", convchar = TRUE)
}
\arguments{
\item{dfrm}{the data frame for which the table should be generated}

\item{x}{vector of x variable(s) in the data frame}

\item{y}{vector of y variable(s) in the data frame (will be cast to generate long format)}

\item{var}{variable within the data frame with the values to be placed in the table}

\item{fill}{character vector of one indicating the character to use in case of missing values}

\item{type}{character vector of one indicating the type of table to generate, see details}

\item{convchar}{logical indicating if special characters should be masked}
}
\value{
The function returns a list with the original dataframe, the table header, table data and other table specifications
}
\description{
This function prepares the data pivotal for tabulation. It is intended to use as a first step
in the creation of a report pivotal table. It is not likely that this function will be used as stand-alone
}
\details{
This function only prepares the data for pivotal tabulation. The base of the function is the dcast
function from plyr to reshape the data and the generation of a table header object to indicate how headers
should be placed within the table. The function also specifies a type argument which includes "latex" or "html",
this is necessary to identify specific character handling (convchar) that differs between HTML and LaTeX.
}
\examples{

data(Indometh)
table_prep(Indometh,"time","Subject","conc")
}
