#' Visualize the effect of varying the m parameter on the mean depth of each sample
#'
#' This function takes the list of dataframes output by optimize_m() as input.
#' The function then uses ggplot2 to visualize the effect of m on depth.
#'
#' @param output A list containing 5 dataframes generated by optimize_m()
#' @return A plot showing the depth of each sample at each given m value
#' @examples
#' vis_depth(output =
#' readRDS(system.file("extdata","optimize.m.output.RDS",package="RADstackshelpR",mustWork=TRUE)))
#' @export
vis_depth <- function(output=NULL){
#bind these variable names to the function
dep <- m <- NULL

#take depth df output from all of these possibilities
#plot hist of depth at each m value on same plot
depth.df<-output$depth
depth.df$m<-as.factor(depth.df$m)
depth.df$dep<-as.numeric(as.character(depth.df$dep))
print("Visualize how different values of m affect average depth in each sample")
  return(
  ggplot2::ggplot(depth.df, ggplot2::aes(x = dep, y = m)) +
    ggridges::geom_density_ridges(jittered_points = TRUE, position = "raincloud", alpha = .35, cex=.5) +
    ggplot2::theme_classic() +
    ggplot2::labs(x = "average depth in each sample", y = "m value") +
    ggplot2::theme(legend.position = "none")
  )
#close function
}
