% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.output.R
\name{write.output}
\alias{write.output}
\title{Output generation and visualization}
\usage{
write.output(input, location, flip = FALSE)
}
\arguments{
\item{input}{a \code{\link{data.frame}} produced by \code{\link{pos.det}}.}

\item{location}{an optional character string containing the location where the output .pdf and .txt file should be stored. If not supplied, the function returns the computed output, which can be stored in an object.}

\item{flip}{logical flag indicating in which direction to plot the cells, i.e. with earlywood at the bottom (default; flip = \code{\link{FALSE}}) or at the top (flip = \code{\link{TRUE}}).}
}
\value{
Plots the detected radial files and writes output according to the \code{\link{is.raptor}} format.
}
\description{
Generating final output graphs and files for the row and position detection. Input data should be provided as produced by \code{\link{pos.det}}.
}
\details{
Function that aids in graphing the output and writing output tables. The generated \code{\link{plot}} provides an overview of the detected cells, rows, and the position of the cells within each radial file. The output table provides the standard output table with three additional columns containing; the "ROW" number and "POSITION" within the row and the "MARKER" column (cf. \code{\link{pos.det}}. This output can provide crucial information that can be used with other packages to generate tracheidograms (cf. de la Cruz & DeSoto, 2015) and link the output to xylogenesis data (cf. Rathgeber et al., 2011).
}
\examples{
\dontrun{
#example to write output
input<-is.raptor(example.data(species="SIB_LARIX"), str = FALSE)
aligned<-align(input)
first<-first.cell(aligned, frac.small = 0.5, yrs = FALSE, make.plot = FALSE)
output<-pos.det(first, swe = 0.3, sle = 3, ec = 1.5, swl = 0.5, sll = 5, lc = 15,
                prof.co = 4, max.cells = 0.5, yrs = FALSE, aligning = FALSE, make.plot = FALSE)
sib_larix<-write.output(output)

#removing rows which are unsuitable
corrections<-data.frame(year=c(2010,2010,2010,2009,2009,2009,2009,2008,2008,
                        2008,2008,2008,2008,2007,2007,2007),
                        row=c(19,15,9,6,11,14,17,5,6,14,17,24,15,2,8,14))
for(i in c(1:nrow(corrections))){
sib_larix[which(sib_larix[,"YEAR"]==corrections[i,1]  &
          sib_larix[,"ROW"]==corrections[i,2] ),"POSITION"]<-rep(NA,length(sib_larix[
          which(sib_larix[,"YEAR"]==corrections[i,1]& sib_larix[,"ROW"]==corrections[i,2] ),
          "POSITION"]))
sib_larix[which(sib_larix[,"YEAR"]==corrections[i,1]  &
          sib_larix[,"ROW"]==corrections[i,2] ),"ROW"]<-rep(NA,length(sib_larix[
          which(sib_larix[,"YEAR"]==corrections[i,1]&sib_larix[,"ROW"]==corrections[i,2] ),
          "POSITION"]))}
SIB_LARIX<-write.output(sib_larix)
for(i in c(1:length(unique(SIB_LARIX[,"YEAR"])))){
row_id<-unique(SIB_LARIX[which(SIB_LARIX[,"YEAR"]==unique(SIB_LARIX[,"YEAR"])[i]),"ROW"],
               na.rm=TRUE)
row_id<-na.omit(row_id[order(row_id)])
for(j in c(1:length(row_id))){
SIB_LARIX[which(SIB_LARIX[,"YEAR"]==unique(SIB_LARIX[,"YEAR"])[i] &
          SIB_LARIX[,"ROW"]==row_id[j]), "ROW"]<-j
}}
}
}
\references{
de la Cruz, M., & DeSoto, L. (2015) tgram: Functions to compute and plot tracheidograms. CRAN: https://cran.r-project.org/web/packages/tgram/tgram.pdf.\cr
\cr
Rathgeber, C.B.K., Longuetaud, F., Mothe, F., Cuny, H., & Le Moguedec, G. (2011) Phenology of wood formation: Data processing, analysis and visualisation using R (package CAVIAR). Dendrochronologia 29, 139-149.
}
