% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEU_power_comparison_Power_vs_Trt.R
\name{SEU_power_comparison_Power_vs_Trt}
\alias{SEU_power_comparison_Power_vs_Trt}
\title{Comparison of Powers for Treatment Effects under Different SEU Randomization
Methods (Binary Responses)}
\usage{
SEU_power_comparison_Power_vs_Trt(n, nstart, p_pbo, p_trt, urn_comp,
nstop, replication, group_allo, add_rule_index, add_rule, add_rule_full,
sig_level)
}
\arguments{
\item{n}{The number of patients. The default is 100.}

\item{nstart}{Burn-in sample size of each arm. The default is n/20.}

\item{p_pbo}{Success rate of placebo (control) arm. The default is 0.3.}

\item{p_trt}{A vector containing success rates of treatment arm.}

\item{urn_comp}{A vector of current urn composition. The default is NULL,
which indicates no ball in the urn.}

\item{nstop}{A vector of stopping cap of sample size for each arm. The trial
stops if at least one arm reaches the corresponding cap.
The default is NULL, which means no cap.}

\item{replication}{the number of replications of the simulation. The default
is 100.}

\item{group_allo}{A number or a vector of group size(s) for allocation.
If a number is given, the allocation ratios will be updated for each batch of
 group_allo samples. If a vector is given, the allocation ratios will be
 updated sequentially in group according to the vector.
 Any value greater than n will be omitted.
The default is group_allo=1, which is the same as group_allo = seq(nstart*length(p)+1,n).}

\item{add_rule_index}{Supply a number of 1, 2 or 3 indicting the
addition rules to target allocation functions.
1 = randomized play-the-winner (RPW) rule that targets the urn allocation
2 = the SEU model that targets Neyman allocation;
3 = the SEU model that targets Rosenberger allocation;'
4 = the SEU model that assigns probability of 0.6+1/K to winner at each step.
The default is 1.}

\item{add_rule}{Supply a user-specified addition rules function of x.df and
arms when add_rule_index is NULL. Default is NULL. (See SEU_BINARY_raw for
details on x.df and arms.)}

\item{add_rule_full}{Indicator of reference data for updating addition rule.
If TRUE, the addition rule is updated by full observation at each group
allocation. If FALSE,the addition rule is updated by each group observation.
The default is FALSE for add_rule_index=1 and TRUE otherwise.}

\item{sig_level}{Significant level (one-sided). The default is 0.05.}
}
\value{
\itemize{
  \item Allocation - Average and standard deviation (SD) of allocation distribution
  \item Estimation - Average and standard deviation of treatment effect
  \item Power - Average power: 1) Chi-square test, 2) one-sided proportion test performed for each of the k-th arm against H0: p_1>p_k without multiplicity adjustment
  \item Plot - Three figures of results: 1) Allocation mean and SD, 2) Estimated mean response and SD, 3) Power of Chi-square test and power of one-sided proportion test
}
}
\description{
Compares the power of a 2-arm design under different treatment effects
for the same sample size and placebo effect through matrices and plots.
}
\details{
'SEU_power_comparison_Power_vs_Trt' reads different treatment effects
and outputs allocation, estimated rates and powers.
}
\examples{

## Default setting
SEU_power_comparison_Power_vs_Trt(
n = 40,
nstart = round(40/20),
p_pbo = 0.3,
p_trt = seq(0,0.3,0.1)+0.3,
urn_comp = NULL,
nstop = NULL,
replication = 5,
group_allo = 1,
add_rule_index = 3,
add_rule = NULL,
add_rule_full = FALSE,
sig_level = 0.05
)

}
