% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTQTE.Khmaladze.fit.R
\name{PTQTE.Khmaladze.fit}
\alias{PTQTE.Khmaladze.fit}
\title{Quantile-Based Permutation Test with an Estimated Nuisance Parameter}
\usage{
PTQTE.Khmaladze.fit(
  Y,
  Z,
  taus = seq(0.1, 0.9, by = 0.05),
  alpha = 0.05,
  n.perm = 999
)
}
\arguments{
\item{Y}{Numeric. Vector of responses.}

\item{Z}{Numeric. Treatment indicator. Z=1 if the unit is in the treatment group, and Z=0 if the unit is in the control group.}

\item{taus}{quantiles at which the process is to be evaluated, if any of the taus lie outside (0,1) then the full process is computed for all distinct solutions.}

\item{alpha}{Significance level.}

\item{n.perm}{Numeric. Number of permutations needed for the stochastic approximation of the p-values. The default is n.perm=999.}
}
\value{
An object of class "PTQTE.Khmaladze" containing at least the following components:

 \item{n_populations}{Number of grups.}
 \item{N}{Sample Size.}
 \item{KS.obs}{Observed two-sample Kolmogorov-Smirnov test statistic based on the quantile process.}
 \item{shift}{The estimated nuisance parameter.}
 \item{rej.rule}{Binary decision for the permutation test, where 1 means rejection.}
 \item{pvalue}{P-value.}
 \item{KS.perm}{Vector. Test statistic recalculated for all permutations used in the stochastic approximation.}
 \item{n_perm}{Number of permutations.}
 \item{sample_sizes}{Groups size.}
}
\description{
A permutation test for testing whether the quantile treatment effects are constant across quantiles. The permutation test considered here is based on the Khmaladze transformation of the quantile process (Koenler and Xiao (2002)), and adapted by Chung and Olivares (2021).
}
\examples{
\dontrun{
dta <- data.frame(Y=rnorm(100),Z=sample(c(0,1), 100, replace = TRUE))
pt.QTE<-PTQTE.Khmaladze.fit(dta$Y,dta$Z,taus=seq(.1,.9,by=0.05),alpha=0.05,n.perm = 499)
summary(pt.QTE)
}
}
\references{
Khmaladze, E. (1981). Martingale Approach in the Theory of Goodness-of-fit Tests. Theory of Probability and its Application, 26: 240–257.
Koenker, R. and Xiao, Z. (2002) Inference on the Quantile Regression Process. Econometrica, 70(4): 1583-1612.
Chung, E. and Olivares, M. (2021). Comment on "Can Variation in Subgroups' Average Treatment Effects Explain Treatment Effect Heterogeneity? Evidence from a Social Experiment."
}
\author{
Maurcio Olivares
}
\keyword{Khmaladze}
\keyword{Permutation}
\keyword{Process}
\keyword{Quantile}
\keyword{Test}
\keyword{Transformation}
