% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeries.R
\name{getSeries}
\alias{getSeries}
\title{Retrieve Data From the Reserve Bank of New Zealand Website}
\usage{
getSeries(
  series,
  option = getDefaultOption(series),
  replaceColumnNames = TRUE,
  fieldForColumnNames = "Series",
  reloadOnlyLatest = TRUE,
  cacheOnly = FALSE,
  destDir = NULL,
  quiet = TRUE,
  wait = 60
)
}
\arguments{
\item{series}{Character string giving the name of the data series to retrieve.}

\item{option}{Character string specifying which format of the data series
to retrieve, if necessary.  For information on the available options
see the help file for the particular series name (for example ?B1
will tell you that the B1 series can be downloaded either as daily
or monthly data, with the former being the default).  This argument
is unnecessary for series that only have one data format.}

\item{replaceColumnNames}{Logical indicating whether to change the column names of
the output data from the Series ID's used in the source
spreadsheets to more informative values based on the
information in the metadata. Defaults to TRUE.}

\item{fieldForColumnNames}{If replaceColumnNames is TRUE then this variable
specifies which columns of the meta data file will be
used to construct the column names.  Defaults to
\dQuote{Series} but sometimes you may want to change
it to \dQuote{Group} or c(\dQuote{Group},
\dQuote{Series}).  \dQuote{SeriesID} is also allowed.}

\item{reloadOnlyLatest}{Logical indicated whether to skip downloading files containing
past data (with a defined endpoint) if they already exist. For example if a series has
separate spreadsheets for start-to-2015 and 2015-onwards then we don't need to repeatedly
download the former item; only the latter one will be updated.}

\item{cacheOnly}{Logical indicating that the RBNZ website should not be read and
the files only loaded from an existing cache on disk.}

\item{destDir}{File path to a directory in which to place the downloaded
spreadsheets. If not specified the value of getOption("RBNZ.destDir") will
be checked. If that is NULL too then the files will be placed into tempdir()
and deleted on exit.}

\item{quiet}{Logical to be passed to utils::download.file.}

\item{wait}{Numeric giving the number of seconds to wait between downloads.
Defaults to 60. Note that this applies to reading the series page
and to each individual spreadsheet download, so a series with one
spreadsheet would have two downloads sixty seconds apart.}
}
\value{
For most series a list containing the fields \dQuote{meta} and
\dQuote{data} which are data frames containing the metadata and
actual data, respectively.  There are a few series that do not follow
this format, and for these the spreadsheets are just downloaded and
read into a list of data frames, one for each sheet, with no organising
or cleaning.
}
\description{
Retrieves data from \url{https://www.rbnz.govt.nz/statistics} for the series
specified by the user.  This involves downloading one or more spreadsheets
and reading them into R.
}
\examples{

## List the available data series.
print(allAvailableSeries())

\dontrun{

## Download exchange rate data and plot NZD vs sterling.
b1 <- getSeries('B1')
plot(b1$data$Date, b1$data$UK_pound_sterling, type = 'l')

## Now use monthly data (previous was daily).
b1_monthly <- getSeries('B1', 'monthly')
plot(b1_monthly$data$Date, b1_monthly$data$UK_pound_sterling,
type = 'l')

}
}
\author{
Jasper Watson
}
