% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{IC_SCR}
\alias{IC_SCR}
\title{Confidence Interval for the Seroconversion Rate (SCR)}
\usage{
IC_SCR(SP_interval, SRR, ages, A_max, limits = c(0, 1))
}
\arguments{
\item{SP_interval}{A vector with the lower and upper limits of seroprevalence.}

\item{SRR}{Seroreversion rate.}

\item{ages}{Vector with the proportions of different ages in the population (age structure).}

\item{A_max}{Maximum age considered in the population.}

\item{limits}{Lower and upper limits for the calculation of \code{SCR}.}
}
\value{
A vector with the lower and upper limits for the seroconversion rate \code{SCR}.
}
\description{
Calculates the confidence interval for the seroconversion rate (SCR) using
the confidence interval of seroprevalence.
}
\examples{
A_max <- 80
age_distribution <- rep(1 / A_max, A_max)
IC_SCR(c(0.1, 0.2), 0.01, age_distribution, A_max, limits = c(0, 1))
}
