% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size.R
\name{sample_s}
\alias{sample_s}
\title{Sample Size Calculation}
\usage{
sample_s(
  SCR,
  RL,
  SRR,
  ages,
  A_max,
  limits,
  max_iter = 10000,
  conf.level = 0.95,
  method = "asymptotic"
)
}
\arguments{
\item{SCR}{Seroconversion rate.}

\item{RL}{Desired relative width.}

\item{SRR}{Seroreversion rate.}

\item{ages}{Vector with the proportions of different ages in the population (age structure).}

\item{A_max}{Maximum age considered in the population.}

\item{limits}{Lower and upper limits for the calculation of \code{SCR}.}

\item{max_iter}{Maximum number of iterations.}

\item{conf.level}{Confidence level (default is 0.95).}

\item{method}{Method for calculating the confidence interval. Available methods: "waldcc" and the methods in IC_SP documentation.}
}
\value{
A list with the required sample size, the confidence interval for
seroprevalence, and the confidence interval for \code{SCR}.
}
\description{
Estimates the required sample size so that the confidence interval width
for SCR does not exceed a specified limit.
}
\details{
**Disclaimer**: The sample size function may not produce accurate values for
scenarios involving extremely low SCR (e.g.,
elimination scenarios). Users are advised to exercise caution and consider
the results critically when applying this function to such cases.
}
\examples{
A_max <- 80
age_distribution <- rep(1 / A_max, A_max)
sample_s(0.03, 1, 0.01, age_distribution, A_max, limits = c(0, 1))
}
