% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_nkr.r
\name{estimate_nkr}
\alias{estimate_nkr}
\alias{estimate_nkr.default}
\alias{estimate_nkr.RCNA_object}
\title{estimate_nkr: Estimate CNA "normal" karyotype ranges}
\usage{
estimate_nkr(obj, ...)

\method{estimate_nkr}{default}(
  obj = NULL,
  df = NULL,
  sample.names = NULL,
  ano.file,
  out.dir = NULL,
  ncpus = 1,
  file.ci.coverage = NULL,
  nkr = 0.9,
  x.norm = NULL,
  norm.cov.matrix = NULL,
  verbose = FALSE,
  ...
)

\method{estimate_nkr}{RCNA_object}(obj, verbose = FALSE, ...)
}
\arguments{
\item{obj}{A RCNA_object type object - parameters will be pulled from the object instead, specifically from the `nkrParams` slot.}

\item{...}{Additional arguments (unused)}

\item{df}{Path to the config file, or a `data.frame` object containing the valid parameters. Valid column names are `file.nkr.coverage`, `x.norm`, and `sample.names`. Additional columns will be ignored.}

\item{sample.names}{Character vector of sample names. Alternatively can be specified in `df`.}

\item{ano.file}{Location of the annotation file. This file must be in CSV format and contain the following information (with column headers as specified): "feature,chromosome,start,end".}

\item{out.dir}{Output directory for results. A subdirectory for results will be created under this + `/nkr/`.}

\item{ncpus}{Integer number of CPUs to use. Specifying more than one allows this function to be parallelized by feature.}

\item{file.ci.coverage}{Character vector listing the input coverage files. Must be the same length as `sample.names`. Alternatively can be specified in `df`.}

\item{nkr}{Numeric between 0 and 1 which specifies the coverage quantile that should be considered a "normal" karyotype range for each position. Lowering this value may increase sensitivity but also Type I error.}

\item{x.norm}{Whether or not to perform normalization for normal female/XX karyotype (default = FALSE). Can be specified for each sample separately via `df` column labeled `x.norm`.}

\item{norm.cov.matrix}{Character file path detailing the location of the normalized coverage matrix generated by this function. Re-using this file between runs can cut down on runtime significantly for large sample sizes. If the file doesn't exist yet it will be created at this location. If this file name ends in ".gz" then the output will be compressed using gzip.}

\item{verbose}{If set to TRUE will display more detail}
}
\value{
A \linkS4class{RCNA_analysis} class object that describes the input parameters and output files generated by this step of the workflow.

A \linkS4class{RCNA_analysis} class object that describes the input parameters and output files generated by this step of the workflow.

A \linkS4class{RCNA_analysis} class object that describes the input parameters and output files generated by this step of the workflow.
}
\description{
This generic function is used to run normal karyotype range estimation.

This function estimates the normal karyotype range for each feature in the annotation file. It creates an .RData object for each feature, which is placed in the output directory under `/nkr`. This intermediate output is used in \link{estimate_feature_score}.

This function estimates the normal karyotype range for each feature in the annotation file. It creates an .RData object for each feature, which is placed in the output directory under `/nkr`. This intermediate output is used in \link{estimate_feature_score}.
}
\details{
This function can be run as a stand-alone or as part of \link{run_RCNA}

The `df` argument corresponds to the `nkrParams` matrix on \linkS4class{RCNA_object}. Valid column names are `sample.names`, `file.ci.coverage`, and `x.norm`. Additional columns will be ignored.

For more parameter information, see \link{estimate_nkr.default}.
}
\examples{
## Run NKR estimation on example object
# See \link{example_obj} for more information on example
example_obj@ano.file <- system.file("examples" ,"annotations-example.csv", package = "RCNA")
\donttest{example_obj}
# Create output directory
dir.create(file.path("output", "nkr"), recursive = TRUE)
# Copy example GC-corrected coverage files
cov.corrected <- system.file("examples", "gc", package = "RCNA")
file.copy(from = cov.corrected, to = "output", recursive = TRUE)
# Run NKR estimation, append results
estimate_nkr_analysisObj <- estimate_nkr(example_obj)
example_obj@commands <- c(example_obj@commands, estimate_nkr_analysisObj)
\dontshow{system("rm -rf output")}
}
\seealso{
\linkS4class{RCNA_object}, \linkS4class{RCNA_analysis}, \link{run_RCNA}
}
