% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSRE.R
\name{Calsamplesize}
\alias{Calsamplesize}
\title{Sample size calculations for detecting a specific alternative}
\usage{
Calsamplesize(data, mu, qa, alpha = 0.05, beta = 0.2)
}
\arguments{
\item{data}{A data frame containing the relevant variables. The names for the variables should be ``Z'' for the treatment assignment, ``Y'' for the treatment outcome, ``A'' for the treatment assignment mechanism, and ``id'' for the cluster ID. The variable for the cluster ID should be a factor.}

\item{mu}{The effect size (i.e. the largest direct effect across treatment assignment mechanisms).}

\item{qa}{The proportions of different treatment assignment mechanisms.}

\item{alpha}{The given significance level (default 0.05).}

\item{beta}{The given power level (default 0.2).}
}
\value{
A list of class \code{sampleSRE} which contains the following item:
\item{samplesize}{ A list of the calculated necessary nubmer of clusters for each assignment mechanism in order to detect a specific alternative with a given power at a given significance level. }
}
\description{
This function calculates the sample size needed to detect a specific alternative hypothesis with a given power at a given significance level.
For the details of the method implemented by this function, see the
references.
}
\references{
Zhichao Jiang, Kosuke Imai (2020).
\dQuote{Statistical Inference and Power Analysis for Direct and Spillover Effects in Two-Stage Randomized Experiments}, \emph{Technical Report}.
}
\author{
Kosuke Imai, Department of Statistics, Harvard University
\email{imai@harvard.edu}, \url{https://imai.fas.harvard.edu/};
Zhichao Jiang, School of Public Health and Health Sciences, University of Massachusetts Amherst
\email{zhichaojiang@umass.edu};
Karissa Huang, Department of Statistics, Harvard College
\email{krhuang@college.harvard.edu}
}
\keyword{experiments}
\keyword{randomized}
\keyword{two-stage}
