% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.SetFData.R
\docType{methods}
\name{RDML.SetFData}
\alias{RDML.SetFData}
\title{Sets fluorescence data vectors to \code{RDML} object}
\arguments{
\item{data}{\code{matrix} containing in the first column data corresponding to 
all fluorescence values in the following columns. The name of the first column 
is the name of variable and names of other column are \code{fdata.names} (links 
to rows at \code{description}).}

\item{description}{output from \code{AsTable} function that describes fluorescence data.}

\item{fdata.type}{'adp' for qPCR, 'mdp' for melting data.}
}
\description{
Sets fluorescence data vectors to \code{RDML} object for specified method
of experiment.
}
\examples{
PATH <- path.package("RDML")
filename <- paste0(PATH, "/extdata/", "stepone_std.rdml")
cfx96 <- RDML$new(filename)
## Use plotCurves function from the chipPCR package to 
## get an overview of the amplification curves
library(chipPCR)
## Extract all qPCR data 
tab <- cfx96$AsTable()
tab2 <- tab
tab2$run.id <- "cpp"
cfx96.qPCR <- as.data.frame(cfx96$GetFData(tab))
cpp <- cbind(cyc = cfx96.qPCR[, 1],
 apply(cfx96.qPCR[, -1], 2, 
   function(y) CPP(x = cfx96.qPCR[, 1], y = y)$y.norm))
cfx96$SetFData(cpp, tab2)
library(ggplot2)
cfx96.gg <- cfx96$GetFData(tab, long.table = TRUE)
cpp.gg <- cfx96$GetFData(tab2,
                         long.table = TRUE)
ggplot(cfx96.gg, aes(x = cyc, y = fluor,
                group=fdata.name)) +
                 geom_line() +
                 ggtitle("Raw data")
ggplot(cpp.gg, aes(x = cyc, y = fluor,
                group=fdata.name)) +
                 geom_line() +
                 ggtitle("CPP processed data")
}
