% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeBandwidth.R
\name{computeBandwidth}
\alias{computeBandwidth}
\title{Compute bandwidth via cross-validation}
\usage{
computeBandwidth(X, sL, sU, method = c("cvsym", "cvasym"), reduce = TRUE)
}
\arguments{
\item{X}{A bivariate data.frame containing the observations. Each row contains one observation.}

\item{sL}{Lower bound \eqn{N^{sL}} for the possible bandwidth parameters (where \eqn{N} is the number of observations).}

\item{sU}{Upper bound \eqn{N^{sU}} for the possible bandwidth parameters (where \eqn{N} is the number of observations).}

\item{method}{"cvsym" uses either a symmetric cross-validation principle (N_1 = N_2) and "cvasym" uses an asymmetric cross-validation principle (i.e. \eqn{N_1} and \eqn{N_2} may attain different values).}

\item{reduce}{In case reduce is set to TRUE, the parameter is chosen from N, N+2, ... instead of N, N+1, N+2, ...}
}
\value{
The chosen bandwidth depending on the data.frame X.
}
\description{
An implementation of the cross-validation principle for the bandwidth selection as presented in Strothmann, Dette and Siburg (2022) <arXiv:2201.03329>.
}
\details{
This function computes the optimal bandwidth given the bivariate observations \eqn{X} of length \eqn{N}.
Currently, there are two different algorithms implemented:
\itemize{
  \item "cvsym" - Computes the optimal bandwidth choice for a square checkerboard mass density according to the cross-validation principle. The bandwidth is a natural number between \eqn{N^{sL}, ..., N^{sU}}
  \item "cvasym" - Computes the optimal bandwidth choice \eqn{(N_1, N_2)} for a non-square checkerboard mass density according to the cross-validation principle.
  The bandwidths \eqn{N_1, N_2} are natural numbers between \eqn{N^{sL}, ..., N^{sU}} and may possibly attain different values.
}
}
\examples{
n <- 20
X <- cbind(runif(n), runif(n))
computeBandwidth(X, sL = 0.25, sU = 0.5, method="cvsym", reduce=TRUE)
}
