\name{REGENT.predict}

\alias{REGENT.predict}

\title{REGENT.predict}

\description{REGENT.predict takes genotype and exposure information for individuals and calculates their absolute and relative risk of disease, and categorises them as reduced, average, elevated or high risk based on the risk categorisation model determined by REGENT.model.} 

\usage{

REGENT.predict(AnalysisName,model,ind,prev=0.001,cv=0.05,sims=100000,Block=100,alpha=0.05,
SmallSampAdjust=0.5)

}

\arguments{

\item{AnalysisName}{String, must be provided. The output file will be named according to this argument, with the suffix "_Predictions.txt". Running multiple analyses with the same name will cause previous files to be overwritten.}

\item{model}{Must be provided. Either a file path string giving the location of a file created by REGENT.model (the main file containing model information), or a variable containing the object returned by REGENT.model.}

\item{ind}{Must be provided. File path giving the location of individual file, which should have columns for each risk factor (with header of SNP names or Factor names as provided to REGENT.model) and a row for each individual. Genotypes are encoded 0, 1 or 2 describing the number of copies of the risk allele (as defined in the model). Environmental factors are encoded 0, 1, 2, 3 etc. depending on how many exposure levels were modelled. The row header contains individual names.}

\item{prev}{Prevalance of the disease or trait. Default 0.001.}

\item{cv}{Coefficient of variation. Default 0.05.}

\item{sims}{Number of simulations to perform for each single factor risk estimate, for obtaining confidence intervals. Default 100000.}

\item{Block}{Number of multilocus genotypes held in memory during confidence interval calculation. Higher values should decrease computation time. We advise increasing this substantially (10000+) on high performance systems. Default 100.}

\item{alpha}{One minus the desired width of confidence intervals around multilocus risk estimates. Default 0.05 giving 95 percent confidence intervals.}

\item{SmallSampAdjust}{Adjustment for small sample sizes, when calculating the standard error of homozygous risk genotypes. Default 0.5.}

}

\value{

Table with columns: Absolute risk, genotype relative risk, lower confidence interval, upper confidence interval, risk category, and borderline category status. 

}

\examples{

#Load example data from package

library(REGENT)

data("REGENT")

write.table(GeneticA,file="GeneticA.txt")
write.table(GeneticB,file="GeneticB.txt")
write.table(EnvironmentalA,file="EnvironmentalA.txt")
write.table(EnvironmentalB,file="EnvironmentalB.txt")
write.table(Inds,file="Inds.txt")

#Create model

x=REGENT.model(AnalysisName="Example",LocusFile="GeneticB.txt",EnvFile="EnvironmentalA.txt")

#Option 1, read model from object

y=REGENT.predict(AnalysisName="Example",model=x,ind="Inds.txt")

#Option 2, read model from file

y=REGENT.predict(AnalysisName="Example",model="Example.txt",ind="Inds.txt")

}

\details{

Email: djmcrouch@gmail.com 

One file is created by REGENT.predict, with the contents of the returned object and the input parameters/data, plus analysis log. 

See the example folder included in  this package for the correct input file format. 

}

\author{Graham Goddard, Daniel Crouch and Cathryn Lewis }

\seealso{\code{\link[REGENT:REGENT.model]{REGENT.model}},\code{\link[REGENT:GeneticA]{GeneticA}},\code{\link[REGENT:GeneticB]{GeneticB}},\code{\link[REGENT:EnvironmentalA]{EnvironmentalA}},\code{\link[REGENT:EnvironmentalB]{EnvironmentalB}},\code{\link[REGENT:Inds]{Inds}}

}
