% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REM_EFA.R
\name{REM_EFA}
\alias{REM_EFA}
\title{Robust Estimation Maximization for Exploratory Factor Analysis}
\usage{
REM_EFA(X, k_range, delta = 0.05, rotation = "oblimin", ctrREM = controlREM())
}
\arguments{
\item{X}{data to analyze; should be a data frame or matrix}

\item{k_range}{vector of the number of factors to consider}

\item{delta}{hyperparameter between 0 and 1 that captures the researcher’s tolerance of incorrectly down-weighting data from the model (default = 0.05)}

\item{rotation}{factor rotation method (default = 'oblimin'); 'varimax' is the only other available option at this time}

\item{ctrREM}{control parameters (default: (steps = 25, tol = 1e-6, maxiter = 1e3, min_weights = 1e-30, max_ueps =  0.3, chk_gamma = 0.9, n = 2e4))}
}
\value{
REM_EFA returns an object of class "REM". The function \code{\link[=summary]{summary()}} is used to obtain estimated parameters from the model. An object of class "REM" in Exploratory Factor Analysis is a list of outputs with four different components for each number of factor: the matched call (call), estimates using traditional expectation maximization (EM_output), estimates using robust expectation maximization (REM_output), and a summary table (summary_table). The list contains the following components:
\item{call}{match call}
\item{model}{model frame}
\item{k}{number of factors}
\item{constraints}{p x k matrix of zeros and ones denoting the factors (rows) and observed variables (columns)}
\item{epsilon}{hyperparameter on the likelihood scale}
\item{AIC_rem}{Akaike information criterion based on REM estimates}
\item{BIC_rem}{Bayesian information criterion based on REM estimates}
\item{mu}{item intercepts}
\item{lambda}{factor loadings}
\item{psi}{unique variances of items}
\item{phi}{factor covariance matrix}
\item{gamma}{average weight}
\item{weights}{estimated REM weights}
\item{ind_lik}{likelihood value for each individual}
\item{lik_rem}{joint log-likelihood evaluated at REM estimates}
\item{lik}{joint log-likelihood evaluated at EM estimates}
\item{mu.se}{standard errors of items intercepts}
\item{lambda.se}{standard errors of factor loadings}
\item{psi.se}{standard errors of unique variances of items}
\item{gamma.se}{standard error of gamma}
\item{summary_table}{summary of EM and REM estimates, SEs, Z statistics, p-values, and 95\% confidence intervals}

The summary function can be used to obtain estimated parameters from the optimal model based on the BIC from the EM and REM algorithms.
}
\description{
This function uses the robust expectation maximization (REM) algorithm to estimate the parameters of an exploratory factor analysis model as suggested by Nieser & Cochran (2023).
}
\examples{
\donttest{
# EFA of Holzinger-Swineford dataset
library(lavaan)
df <- HolzingerSwineford1939
data = df[,-c(1:6)]

model_EFA = REM_EFA(X = data, k_range = 1:3)
summary(model_EFA)
}
}
\references{
Nieser, K. J., & Cochran, A. L. (2023). Addressing heterogeneous populations in latent variable settings through robust estimation. Psychological methods, 28(1), 39.
}
\seealso{
\code{\link[=REM_CFA]{REM_CFA()}}, \code{\link[=summary.REMLA]{summary.REMLA()}} for more detailed summaries, \code{\link[GPArotation:rotations]{GPArotation::oblimin()}} and \code{\link[=varimax]{varimax()}} for details on the rotation
}
\author{
Bryan Ortiz-Torres (bortiztorres@wisc.edu); Kenneth Nieser (nieser@stanford.edu)
}
