% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{initStrat}
\alias{initStrat}
\title{Initialization strategy}
\usage{
initStrat(
  project,
  alpha,
  ObsModel.transfo,
  Nb_genes = 2,
  trueValue = NULL,
  pop.set = NULL,
  useSettingsInAPI = FALSE,
  conditionalDistributionSampling = FALSE,
  print = TRUE,
  digits = 2,
  unlinkTemporaryProject = TRUE,
  seed = NULL
)
}
\arguments{
\item{project}{directory of the Monolix project (in .mlxtran). If NULL, the current loaded project is used (default is NULL).}

\item{alpha}{named list of named vector "\code{alpha0}", "\code{alpha1}" (all \code{alpha1} are mandatory). The name of \code{alpha$alpha0} and \code{alpha$alpha1} are the observation model names from the monolix project to which they are linked (if the observations models are defined whithout intercept, alpha$alpha0 need to be set to the vector NULL).}

\item{ObsModel.transfo}{list containing two lists of transformations and two vectors linking each transformations to their observation model name in the Monolix project. The list should include identity transformations and be named \code{S} and \code{R}. The two vectors should be named \code{linkS} and \code{linkR}.

Both \code{S} (for the direct observation models) and \code{linkS}, as well as \code{R} (for latent process models) and \code{linkR}, must have the same length.

\itemize{
  \item\code{S}: a list of transformations for the direct observation models. Each transformation corresponds to a variable \eqn{Y_p=h_p(S_p)}, where the name indicates which dynamic is observed (from \code{dynFUN});  \item\code{linkS} : a vector specifying the observation model names (that is used in the monolix project, \code{alpha1}, etc.) for each transformation, in the same order as in \code{S};

  \item\code{R}: similarly, a list of transformations for the latent process models. Although currently there is only one latent dynamic, each \eqn{s_k, k\leq K} transformation corresponds to the same dynamic but may vary for each \eqn{Y_k} observed. The names should match the output from \code{dynFUN}; \item \code{linkR} : a vector specifying the observation model names for each transformation, in the same order as in \code{R}.
}}

\item{Nb_genes}{Size of group of genes.}

\item{trueValue}{-for simulation purposes- named vector of true value for parameters.}

\item{pop.set}{population parameters setting for initialization (see details).}

\item{useSettingsInAPI}{logical, if the settings for SAEM should not be changed from what is currently set in the project.}

\item{conditionalDistributionSampling}{logical, if conditional distribution estimation should be done on the final project.}

\item{print}{logical, if the results and algotihm steps should be displayed in the console (default to TRUE).}

\item{digits}{number of digits to print (default to 2).}

\item{unlinkTemporaryProject}{If temporary project (of genes group) is deleted (defaut: TRUE)}

\item{seed}{value of the seed used to initialize the group (see set.seed).}
}
\value{
a list of outputs for every group of genes tested with composition of the group, final parameter estimates, final scores estimates (OFV, AIC, BIC, BICc), temporary project directory. The final selected set is initialize in the project.
}
\description{
Selecting an initialization point by grouping biomarkers of project and running the SAEM. Initial condition is then selected using maximum log-likelihood.
}
\details{
For population parameter estimation settings, see (<https://monolixsuite.slp-software.com/r-functions/2024R1/setpopulationparameterestimationsettings>).
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

initStrat(project,alpha,ObsModel.transfo,seed=1710)
}
}
