% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.pk.R
\name{model.pk}
\alias{model.pk}
\title{Generate trajectory of PK model}
\usage{
model.pk(t, y, parms)
}
\arguments{
\item{t}{vector of time ;}

\item{y}{initial condition, named vector of form c(C=C0) ;}

\item{parms}{named vector of model parameter ; should contain either "\code{Cl}" and "\code{V}" or "\code{ka}".}
}
\value{
Matrix of time and observation of Concentration C.
}
\description{
The administration is via a bolus. The PK model has one compartment (volume V) and a linear elimination (clearance Cl). The parameter ka is defined as \eqn{ ka=\frac{Cl}{V}}.
}
\examples{
res <- model.pk(seq(0,30,1),c(C=100),parms=c(ka=1))

plot(res)
}
\seealso{
\code{\link{indParm}}.
}
