\name{convertToPerVarScoresForSeurat}
\alias{convertToPerVarScoresForSeurat}
\title{Utility function to that converts RESET scores contained in a Seurat object to/from per-variable scores}
\description{
Utility function that converts the scores generated by \link{resetForSeurat} to or from per-variable scores. 
This has the same effect as the \code{per.var} argument to \link{resetForSeurat}.
Conversion to per-variable scores will divide each overall score and each sample-level score by the scaled size of the associated gene set.
The gene set sizes are scaled by dividing by the mean size among all tested sets (this will reset in scores not changing in magnitude for sets of mean size). Conversion from per-variable scores will instead multiply scored by the scaled gene set size.
}
\usage{
    convertToPerVarScoresForSeurat(seurat.data, gene.set.collection, to.per.var=TRUE)
}
\arguments{
\item{seurat.data}{The Seurat object returned from a call to \link{resetForSeurat}.}
\item{gene.set.collection}{List of m gene sets for which scores are computed.
    Each element in the list corresponds to a gene set and the list element is a vector
    of indices for the genes in the set. The index value is defined relative to the
    order of genes in the Seurat active assay. This needs to be the same gene set collection
    used in the call to \link{resetForSeurat}.}
\item{to.per.var}{If true, the scores are converted to a per-variable format by dividing each score by the size of the associated variable set size.
  If false, scores are converted from a per-variable format by multiplying by the associated variable set size.}
}
\value{
Version of the Seurat object where the RESET scores have been appropriately converted to or from a per-variable format.
}
\seealso{\code{\link{resetForSeurat}}}
\keyword{file}
\examples{
    # Only run example code if Seurat package is available
    if (requireNamespace("Seurat", quietly=TRUE) & requireNamespace("SeuratObject", quietly=TRUE)) {
        # Define a collection with three overlapping gene sets of different sizes
        collection=list(set1=1:10, set2=1:20, set3=6:10)
        # Execute on the pbmc_small scRNA-seq data set included with SeuratObject
        # See vignettes for more detailed Seurat examples
        reset.out = resetForSeurat(seurat.data=SeuratObject::pbmc_small,
            num.pcs=2, k=2,
            gene.set.collection=collection)
        # Retrieve the overall scores
        reset.out@assays$RESET@meta.features
        # Convert the scores to a per-variable format
        reset.out.2 = convertToPerVarScoresForSeurat(seurat.data=reset.out,
            gene.set.collection=collection)
        # Retrieve the overall scores
        reset.out.2@assays$RESET@meta.features
    }
}
