% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesise_data.R
\name{export_empty_cor_matrix}
\alias{export_empty_cor_matrix}
\title{Export an empty correlation matrix}
\usage{
export_empty_cor_matrix(
  marginals,
  folder_path,
  file_name = "correlation_matrix.csv",
  create_folder = TRUE
)
}
\arguments{
\item{marginals}{The marginal distributions}

\item{folder_path}{Folder to export to.}

\item{file_name}{(optional) file name, Default: 'correlation_matrix.csv'}

\item{create_folder}{Whether the folder should be created, Default: TRUE}
}
\value{
No return value, called for exportation of files.
}
\description{
A function to export a correlation matrix with
the required variables as a csv file.
}
\details{
This function will export an empty correlation matrix
as a csv file, it will contain all the necessary variables including
dummy variables for factors. Dummy variables for factors may contain
a missing category to represent missing data. Correlations should be
added to the empty CSV and the imported using the
\code{\link{import_marginal_distributions}} function.
Correlations should be supplied using rank order correlations.
The correlation matrix should be symmetric and positive semi definite.
}
\examples{
\dontrun{
 marginals <- import_marginal_distributions()
 export_empty_cor_matrix(
   marginals,
   folder_path = tempdir()
  )
}
}
\seealso{
\code{\link{import_marginal_distributions}}
\code{\link{import_cor_matrix}}
}
