% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesise_data.R
\name{import_cor_matrix}
\alias{import_cor_matrix}
\title{Import a correlation matrix}
\usage{
import_cor_matrix(file_path = "./correlation_matrix.csv")
}
\arguments{
\item{file_path}{A path to the csv file, Default: './correlation_matrix.csv'}
}
\value{
a matrix of correlations that can be used with
\code{\link{synthesise_data}}
}
\description{
Imports a correlation matrix from a csv file generated by
\code{\link{export_empty_cor_matrix}}
}
\details{
A function to import the user specified correlations
generated from the csv file exported by the
\code{\link{export_empty_cor_matrix}} function.
Correlations should be entered into the CSV file,
using rank order correlations. The correlation matrix
should be symmetric and be positive semi definite.
}
\examples{
\dontrun{
  import_cor_matrix("correlation_matrix.csv")
}
}
\seealso{
\code{\link{export_empty_cor_matrix}}
\code{\link[matrixcalc]{is.positive.semi.definite}}
}
