% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfp.R
\name{is.TFPmodel}
\alias{is.TFPmodel}
\title{\code{TFPmodel} object check}
\usage{
is.TFPmodel(object, return.logical = FALSE)
}
\arguments{
\item{object}{An object to be tested.}

\item{return.logical}{If \code{return.logical = FALSE} (default), an error message is printed
if the object is not of class \code{TFPmodel}. If \code{return.logical = TRUE}, a logical
value is returned.}
}
\value{
A logical value or nothing, depending on the value of \code{return.logical}.
}
\description{
Tests whether the input object is a valid object of class \code{TFPmodel}.
}
\examples{
# load data for Germany
data("gap")
data("indicator")
country <- "Germany"
tsList <- amecoData2input(gap[[country]], alpha = 0.65)

# compute cubs indicator
namesCubs <- c("indu", "serv", "buil")
namesVACubs <- paste0("va", namesCubs)
tscubs <- cubs(
  tsCU = gap[[country]][, namesCubs],
  tsVA = gap[[country]][, namesVACubs]
)
tsList <- c(tsList, tscubs)

# define tfp model
model <- TFPmodel(
  tsl = tsList, trend = "DT", cycle = "RAR2",
  cycleLag = 2, cubsErrorARMA = c(1, 0)
)
is.TFPmodel(model, return.logical = TRUE)
attr(model, "cubs")$cycleLag <- 1
is.TFPmodel(model, return.logical = TRUE)
}
