% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarking_utils.R
\name{PrintDenseMatrixMicrobenchmarkResults}
\alias{PrintDenseMatrixMicrobenchmarkResults}
\title{Prints results of a dense matrix microbenchmark}
\usage{
PrintDenseMatrixMicrobenchmarkResults(benchmarkName, numberOfThreads,
  dimensionParameters, numberOfSuccessfulTrials, trialTimes,
  averageWallClockTimes, standardDeviations)
}
\arguments{
\item{benchmarkName}{character string specifying the name of the
microbenchmark}

\item{numberOfThreads}{the number of threads all of the performance trials
were conducted with}

\item{dimensionParameters}{an integer vector specifying the dimension
parameters the microbenchmark uses to define the matrix dimensions to be
tested with; length is assumed to be greater than zero}

\item{numberOfSuccessfulTrials}{an integer vector specifying the number of
performance trials that were successfully performed for each matrix tested}

\item{trialTimes}{a real matrix with each column containing the run times
of all of the successful performance trials associated with a particular
matrix.  The number of valid entries in each column are specified by the
entries in the \code{numberOfSuccessfulTrials} vector}

\item{averageWallClockTimes}{a vector of average wall clock times computed
for each matrix tested during the performance trials}

\item{standardDeviations}{a vector of standard deviations of the wall clock
times obtained for each matrix tested during the performance trials}
}
\description{
\code{PrintDenseMatrixMicrobenchmarkResults} prints performance results for a
dense matrix microbenchmark to standard output in a format that is easily
human readable
}
\details{
This function prints the performance results obtained by a dense matrix
microbenchmark for matrices of various dimensions.  The results include
summary statistics for each matrix tested.  The summary statistics
include the minimum, maximum, average, and standard deviation of the wall
clock times obtained by the performance trials with respect to each matrix
tested.
}
