% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarking_utils.R
\name{WriteClusteringPerformanceResultsCsv}
\alias{WriteClusteringPerformanceResultsCsv}
\title{Appends performance test results of a clustering microbenchmark to a file in
CSV format}
\usage{
WriteClusteringPerformanceResultsCsv(numberOfThreads, numberOfFeatures,
  numberOfFeatureVectors, numberOfClusters, averageWallClockTime,
  standardDeviation, csvResultsFileName)
}
\arguments{
\item{numberOfThreads}{the number of threads all of the performance trials
were conducted with}

\item{numberOfFeatures}{the number of features, i.e. the dimension of the
feature vector}

\item{numberOfFeatureVectors}{the number of feature vectors in the data set}

\item{numberOfClusters}{the number of clusters in the data set}

\item{averageWallClockTime}{average wall clock time computed for the data
set tested during the performance trials}

\item{standardDeviation}{standard deviation of the wall clock times obtained
for the performance trials}

\item{csvResultsFileName}{the CSV results file the performance result will be
appended to}
}
\description{
\code{WriteClusteringPerformanceResultsCsv} appends performance results
for a clustering for machine learning microbenchmark to a CSV file.
}
\details{
This function appends the performance results obtained by a single clustering
for machine learning microbenchmark conducted with a specific data set.
If the CSV file does not exist, header information is printed on the first
line to describe the subsequent entries.  Each entry includes the
number of features, number of feature vectors, and number of clusters in the
data set.  The performance results included in each entry are the average of
the wall clock times obtained for the performance trials, the standard
deviation of the performance trial wall clock times, and the number of
threads the performance trials were conducted with.
}
