% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StationaryFrequencyAnalysis.R
\name{CalculateEnergyInPSDBands}
\alias{CalculateEnergyInPSDBands}
\title{CalculateSPDBandsEnergy}
\usage{
CalculateEnergyInPSDBands(
  HRVData,
  indexFreqAnalysis = length(HRVData$FreqAnalysis),
  ULFmin = 0,
  ULFmax = 0.03,
  VLFmin = 0.03,
  VLFmax = 0.05,
  LFmin = 0.05,
  LFmax = 0.15,
  HFmin = 0.15,
  HFmax = 0.4
)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information 
related to it.}

\item{indexFreqAnalysis}{An integer referencing the data structure that contains 
the PSD analysis.}

\item{ULFmin}{Lower limit ULF band used for distinguish the ULF band.}

\item{ULFmax}{Upper limit ULF band used for distinguish the ULF band.}

\item{VLFmin}{Lower limit VLF band.}

\item{VLFmax}{Upper limit VLF band.}

\item{LFmin}{Lower limit LF band.}

\item{LFmax}{Upper limit LF band.}

\item{HFmin}{Lower limit HF band.}

\item{HFmax}{Upper limit HF band.}
}
\value{
A vector containing the energy of the ULF, VLF, LF and HF bands in the
PSD.
}
\description{
Calculates the Energy in the bands of the Power Spectral Density
(PSD).
}
\examples{
\dontrun{
data(HRVData)
HRVData=BuildNIHR(HRVData)
HRVData=FilterNIHR(HRVData)
# Frequency analysis requires interpolated data (except Lomb)
HRVData=InterpolateNIHR(HRVData)
HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,1,"pgram",doPlot = F)
# get Energy in the default ULF, VLF and LF frequency bands.
# We modify the limits for the HF band
CalculateEnergyInPSDBands(HRVData, 1, HFmin = 0.15, HFmax = 0.3) 
}
}
\seealso{
\code{\link{PlotPSD}}, \code{\link{CalculatePSD}}.
}
