% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfFroc2Roc.R
\name{DfFroc2Roc}
\alias{DfFroc2Roc}
\title{Convert an FROC dataset to an ROC dataset}
\usage{
DfFroc2Roc(dataset)
}
\arguments{
\item{dataset}{The FROC dataset to be converted, \code{\link{RJafroc-package}}.}
}
\value{
An ROC dataset with \strong{finite ratings} in NL[,,1:K1,1] and LL[,,1:K2,1].
}
\description{
Convert an FROC dataset to a highest rating inferred ROC dataset
}
\details{
The first member of the ROC dataset is \code{NL}, whose 3rd dimension has
length \code{(K1 + K2)}, the total number of cases. Ratings of cases \code{(K1 + 1)} 
through \code{(K1 + K2)} are \code{-Inf}. \strong{This is because in an ROC dataset 
FPs are only possible on non-diseased cases.}The second member of the list is \code{LL}. 
Its 3rd dimension has length K2, the number of diseased cases.  \strong{This is 
because TPs are only possible on diseased cases}. For each case the  
inferred ROC rating is the highest of all FROC ratings on that case. If a case has 
no marks, a \strong{finite ROC rating, guaranteed to be smaller than the rating on 
any marked case}, is assigned to it. The dataset structure is shown below:
\itemize{
\item{\code{NL}}{ Ratings array [1:I, 1:J, 1:(K1+K2), 1], of false positives, FPs}
\item{\code{LL}}{ Ratings array [1:I, 1:J, 1:K2, 1], of true positives, TPs}
\item{\code{perCase}}{ array [1:K2], number of lesions per diseased case}
\item{\code{IDs}}{ array [1:K2, 1], labels of lesions on diseased cases}
\item{\code{weights}}{ array [1:K2, 1], weights (or clinical importances) of lesions}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ [1:I] inherited modality labels}
\item{\code{readerID}}{ [1:J] inherited reader labels}
}
}
\examples{
rocDataSet <- DfFroc2Roc(dataset05)
rocSpDataSet <- DfFroc2Roc(datasetFROCSpC)

## in the following example, because of the smaller number of cases, 
## it is easy to see the process at work:

set.seed(1);K1 <- 3;K2 <- 5
mu <- 1;nu <- 0.5;lambda <- 2;zeta1 <- 0
lambda_i <- UtilRSM2Intrinsic(mu,lambda,nu)$lambda_i
nu_i <- UtilRSM2Intrinsic(mu,lambda,nu)$nu_i
Lmax <- 2;Lk2 <- floor(runif(K2, 1, Lmax + 1))
frocDataRaw <- SimulateFrocDataset(mu, lambda_i, nu_i, zeta1, I = 1, J = 1, 
K1, K2, perCase = Lk2)
hrData <- DfFroc2Roc(frocDataRaw)

## print("frocDataRaw$ratings$NL[1,1,,] = ")
## print("hrData$ratings$NL[1,1,1:K1,] = ")
## print("frocDataRaw$ratings$LL[1,1,,] = ")
## print("hrData$ratings$LL[1,1,,] = ")

## following is the output

## [1] "frocDataRaw$ratings$NL[1,1,,] = "
## [,1]      [,2]      [,3] [,4]
## [1,] 2.4046534 0.7635935      -Inf -Inf
## [2,]      -Inf      -Inf      -Inf -Inf
## [3,] 0.2522234      -Inf      -Inf -Inf
## [4,] 0.4356833      -Inf      -Inf -Inf
## [5,]      -Inf      -Inf      -Inf -Inf
## [6,]      -Inf      -Inf      -Inf -Inf
## [7,]      -Inf      -Inf      -Inf -Inf
## [8,] 0.8041895 0.3773956 0.1333364 -Inf

## > ## print("hrData$ratings$NL[1,1,1:K1,] = ")
## [1] "hrData$ratings$NL[1,1,1:K1,] = "
## [1] 2.4046534      -Inf 0.2522234
## > ## print("frocDataRaw$ratings$LL[1,1,,] = ")
## [1] "frocDataRaw$ratings$LL[1,1,,] = "
## [,1] [,2]
## [1,]      -Inf -Inf
## [2,] 1.5036080 -Inf
## [3,] 0.8442045 -Inf
## [4,] 1.0467262 -Inf
## [5,]      -Inf -Inf
## > ## print("hrData$ratings$LL[1,1,,] = ")
## [1] "hrData$ratings$LL[1,1,,] = "
## [1] 0.4356833 1.5036080 0.8442045 1.0467262 0.8041895
## Note that rating of the first and the last diseased case came from NL marks


}
