% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset04}
\alias{dataset04}
\title{Federica Zanca FROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:5, 1:4, 1:200, 1:7], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:5, 1:4, 1:100, 1:3], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:100], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:100, 1:3], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:100, 1:3], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset04", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "FROC", the data type}
\item{\code{descriptions$name}}{, chr "FEDERICA", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:5, 1:4, 1:200, 1:4], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:5] "1" "2" "3" "4" "5", treatment labels}
\item{\code{descriptions$readerID}}{, chr [1:4] "1" "3" "4" "5", reader labels}
}
}
\usage{
dataset04
}
\description{
This is referred to in the book as the "FED" dataset. It consists of 200 mammograms, 
100 of which contained one to 3 simulated microcalcifications,
interpreted in five treatments (basically different image processing algorithms) by four 
radiologists using the FROC paradigm and a 5-point rating scale. The maximum number of NLs 
per case, over the entire dataset was 7 and the dataset contained at least one diseased 
mammogram with 3 lesions. The Excel file containing this dataset is 
/inst/extdata/datasets/FZ_ALL.xlsx. The normal cases are labeled 100:199 while the normal 
cases are labeled 0:99.
}
\examples{
str(dataset04)
PlotEmpiricalOperatingCharacteristics(dataset = dataset04, opChType = "wAFROC")$Plot


}
\references{
Zanca F et al. Evaluation of clinical image processing algorithms used 
in digital mammography. Medical Physics. 2009;36(3):765-775.
}
\keyword{datasets}
