% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeG.R
\name{computeG}
\alias{computeG}
\title{Compute the mean projection of unit leaf area on the plane perpendicular to beam direction, namely, G parameter.}
\usage{
computeG(LeafAngleZ, FractionZ, LeafAngleA, FractionA, theta, alpha)
}
\arguments{
\item{LeafAngleZ}{The center angles list of leaf zenith angle intervals.}

\item{FractionZ}{The leaf area fraction list given leaf zenith angle intervals list.}

\item{LeafAngleA}{The center angles list of leaf azimuth angle intervals.}

\item{FractionA}{The leaf area fraction list given leaf azimuth angle intervals list.}

\item{theta}{The zenith angle of beam direction.}

\item{alpha}{The azimuth angle of beam direction.}
}
\value{
The mean projection of unit leaf area on the plane perpendicular to beam direction, namely, G value.
}
\description{
Compute the mean projection of unit leaf area on the plane perpendicular to beam direction, namely, G parameter.
}
\examples{
angleZ<-c(4.5, 13.5, 22.5, 31.5, 40.5, 49.5, 58.5, 67.5, 76.5, 85.5)
angleA<-c(10,30,50,70,90,110,130,150,170,190,210,230,250,270,290,310,330,350)
sADis<-sysAziDis()
sZDis<-sphericalDis()
for(solarZenith in 10:80)
{
  print(computeG(angleZ,sZDis,angleA,sADis,solarZenith,40))
}

}
\references{
Wang, W. M., Li, Z. L., & Su, H. B. (2007). 
Comparison of leaf angle distribution functions: effects on extinction coefficient and 
fraction of sunlit foliage. Agricultural and Forest Meteorology, 143(1), 106-122.
}
\author{
Wei-Min Wang (wmwang AT gmail.com)
}
