% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{RM_norm}
\alias{RM_norm}
\title{Generate a normal random matrix}
\usage{
RM_norm(N, mean = 0, sd = 1, symm = FALSE, cplx = FALSE, herm = FALSE)
}
\arguments{
\item{N}{number of dimensions of the square matrix}

\item{mean}{mean of the normal distribution of entries}

\item{sd}{standard deviation of the normal distribution of entries}

\item{symm}{indicates whether the matrix should be symmetric (equal to its transpose).
Reserved for when cplx = FALSE, otherwise use herm = TRUE.}

\item{cplx}{indicates whether the matrix should have complex entries.}

\item{herm}{indicates whether the matrix should be hermitian (equal to its conjugate transpose).
Reserved for when cplx = TRUE, otherwise use symm = TRUE.}
}
\value{
A random matrix with normally distributed entries.
}
\description{
Normal random matrices are matrices with normally distributed entries. These matrices
 are extensively studied in random matrix theory.
}
\examples{
# N(1,2) distributed matrix
P <- RM_norm(N = 3, mean = 1, sd = 2)

# N(0,5) distributed matrix with real symmetric entries
P <- RM_norm(N = 7, sd = 5, symm = TRUE)

# 7x7 standard normal matrix with complex entries
Q <- RM_norm(N = 7, cplx = TRUE)

# N(2,1) distributed matrix with hermitian complex entries
Q <- RM_norm(N = 5, mean = 2, cplx = TRUE, herm = TRUE)

}
