% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARA.R
\name{apply.MARA}
\alias{apply.MARA}
\title{Apply the MARA (Magnitude of the Area for the Ranking of Alternatives) Method}
\usage{
apply.MARA(mat, weights, beneficial.vector)
}
\arguments{
\item{mat}{A numeric matrix with each row an alternative and each column a criterion.}

\item{weights}{A numeric vector of weights for each criterion (same length as number of columns).}

\item{beneficial.vector}{An integer vector of column indices for the beneficial (max) criteria.}
}
\value{
A numeric vector of MARA scores for each alternative.
}
\description{
MARA ranks alternatives based on multiple criteria, each weighted. Columns
in beneficial.vector are treated as "max" (beneficial), and columns
not in beneficial.vector are treated as "min" (cost).
}
\details{
The following function is the R implementation of the python function mara from the pyDecision package
Source: https://github.com/Valdecy/pyDecision/blob/master/pyDecision/algorithm/mara.py
}
\examples{
# Example
mat <- matrix(c(10, 2,
                20, 4,
                15, 5),
              nrow = 3, byrow = TRUE)
weights <- c(0.7, 0.3)
beneficial.vector <- c(1)  # First column is beneficial (max); second is cost (min)
apply.MARA(mat, weights, beneficial.vector)

}
