% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_completed}
\alias{get_completed}
\alias{get_completed.rdmc_tuned}
\alias{get_completed.rdmc}
\alias{get_completed.soft_impute_tuned}
\alias{get_completed.soft_impute}
\alias{get_completed.median_impute}
\alias{get_completed.mode_impute}
\alias{get_imputed}
\title{Extract the completed (imputed) data matrix}
\usage{
get_completed(object, ...)

\method{get_completed}{rdmc_tuned}(object, ...)

\method{get_completed}{rdmc}(object, which, ...)

\method{get_completed}{soft_impute_tuned}(object, discretized = NULL, ...)

\method{get_completed}{soft_impute}(object, which, discretized = NULL, ...)

\method{get_completed}{median_impute}(object, discretized = NULL, ...)

\method{get_completed}{mode_impute}(object, ...)

get_imputed(object, ...)
}
\arguments{
\item{object}{an object returned by a matrix completion algorithm.}

\item{\dots}{additional arguments to be passed down to methods.}

\item{which}{an integer specifying the index of the regularization 
parameter for which to extract the completed data matrix.}

\item{discretized}{a logical indicating if the completed data matrix with 
or without the discretization step should be extracted. The default is 
\code{TRUE} if the discretization step was performed and \code{FALSE} 
otherwise.}
}
\value{
The completed (i.e., imputed) data matrix.
}
\description{
Extract the completed (i.e., imputed) data matrix from an object returned by 
a matrix completion algorithm.
}
\note{
Matrix completion and imputation are synonymous terms used in 
different streams of the literature, hence \code{get_imputed()} is an 
alias for \code{get_completed()} with the same functionality.
}
\examples{
# toy example derived from MovieLens 100K dataset
data("MovieLensToy")
# robust discrete matrix completion with hyperparameter tuning
set.seed(20250723)
fit <- rdmc_tune(MovieLensToy, 
                 lambda = fraction_grid(nb_lambda = 6),
                 splits = holdout_control(R = 5))
# extract completed matrix with optimal regularization parameter
X_hat <- get_completed(fit)
head(X_hat)

# for more examples, see the help files of other functions for 
# matrix completion and imputation methods

}
\seealso{
\code{\link{rdmc_tune}()}, \code{\link{soft_impute_tune}()}, 
\code{\link{median_impute}()}, \code{\link{mode_impute}()}
}
\author{
Andreas Alfons and Aurore Archimbaud
}
\keyword{utilities}
