% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/investport.R
\name{InvestmentPortfolio}
\alias{InvestmentPortfolio}
\title{Construct Portfolio}
\usage{
InvestmentPortfolio(data, method, spec, constraints = "LongOnly")
}
\arguments{
\item{data}{multivariate returns, must be "timeSeries" type}

\item{method}{porofolio type, one of "fea", "minrisk", "globalminrisk" and "sharp"}

\item{spec}{specificition of portfolio}

\item{constraints}{constraints of trade}
}
\value{
A portfolio
}
\description{
Construct four types portfolio with specificition and constraints.
}
\examples{
library(fPortfolio)
names <- c("swan", "bear", "tiger")
date <- as.Date("2015-01-01") + days(0:179)
mu <- c(0.2, 0.08, 0.1)
sigma <- matrix(c(1, 0.25, -0.3, 0.25, 0.25, 0, -0.3, 0, 0.36), 3, 3)
allret <- rMvReturnSim(names, date, mu, sigma)
tsret <- as.timeSeries(allret)
feaSpec <- portfolioSpec()
setWeights(feaSpec) <- rep(1 / 3, times = 3)
InvestmentPortfolio(tsret, "fea", feaSpec)
}
\references{
Markowitz H. 1952. "Portfolio Selection", The Journal of Finance, 7(1), 77–91. doi: 10.2307/2975974.
}
