% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordace.R
\name{concordance_indexes}
\alias{concordance_indexes}
\alias{cp_auc}
\alias{ncp_auc}
\title{Concordance indexes}
\usage{
cp_auc(
  data = NULL,
  response,
  predictor,
  lower_threshold,
  upper_threshold,
  ratio,
  .condition = NULL
)

ncp_auc(
  data = NULL,
  response,
  predictor,
  lower_threshold,
  upper_threshold,
  ratio,
  .condition = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{lower_threshold, upper_threshold}{Two numbers between 0 and 1,
inclusive.
These numbers represent lower and upper bounds of the region where to
apply calculations.}

\item{ratio}{Ratio or axis where to apply calculations.
\itemize{
\item If \code{"tpr"}, only points within the specified region of TPR, y axis, will be
considered for calculations.
\item If \code{"fpr"}, only points within the specified region of FPR, x axis, will be
considered for calculations.
}}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}
}
\value{
A numeric value representing index score for the partial area under ROC
curve.
}
\description{
Concordance derived indexes allow calculation and explanation of area under
ROC curve in a specific region. They use a dual perspective since they
consider both TPR and FPR ranges which enclose the region of interest.

\code{cp_auc()} applies \emph{concordan partial area under curve} (CpAUC), while
\code{ncp_auc()} applies its normalized version by dividing by the total area.
}
\examples{
# Calculate cp_auc of Sepal.Width as a classifier of setosa especies in
# FPR = (0, 0.1)
cp_auc(
  iris,
  response = Species,
  predictor = Sepal.Width,
  lower_threshold = 0,
  upper_threshold = 0.1,
  ratio = "fpr"
)
# Calculate ncp_auc of Sepal.Width as a classifier of setosa especies in
# FPR = (0, 0.1)
ncp_auc(
  iris,
  response = Species,
  predictor = Sepal.Width,
  lower_threshold = 0,
  upper_threshold = 0.1,
  ratio = "fpr"
)
}
\references{
Carrington, André M., et al. A new concordant partial AUC and partial c
statistic for imbalanced data in the evaluation of machine learning
algorithms. \emph{BMC medical informatics and decision making} 20 (2020): 1-12.
}
