% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nuisance_Parameters.R
\name{nuisParsFn}
\alias{nuisParsFn}
\title{Nuisance Parameters Computation}
\usage{
nuisParsFn(mu = 0.01, sd = 0.05, c = 0, alpha = 0.1, beta = 0.1)
}
\arguments{
\item{mu}{Mean parameter.}

\item{sd}{Standard deviation parameter.}

\item{c}{Constant value for threshold.}

\item{alpha}{Parameters for the lower tail quantile.}

\item{beta}{Parameter for the upper tail quantile.}
}
\value{
List of nuisance parameters.
}
\description{
\code{nuis.pars} returns the value of the nuisance parameters used in the evaluation of the shape of influence functions for risk and performance measures.
}
\details{
For further details on the usage of the \code{nuisParsFn} function, please refer to Section 3.1 for the \code{RPEIF} vignette.
}
\examples{
# Nuisance parameters using default values
defaultNuisance <- nuisParsFn()

# Nuisance parameters using specified values
specifiedNuisance <- nuisParsFn(mu=0.02, sd=0.1, c=0.01, alpha=0.05, beta=0.1)

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
