% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.R
\name{postgresHasDefault}
\alias{postgresHasDefault}
\alias{postgresDefault}
\title{Check if default database is available.}
\usage{
postgresHasDefault(...)

postgresDefault(...)
}
\arguments{
\item{...}{Additional arguments passed on to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\description{
RPostgres examples and tests connect to a default database via
\verb{dbConnect(}\code{\link[=Postgres]{Postgres()}}\verb{)}. This function checks if that
database is available, and if not, displays an informative message.

\code{postgresDefault()} works similarly but returns a connection on success and
throws a testthat skip condition on failure, making it suitable for use in
tests.
}
\examples{
if (postgresHasDefault()) {
  db <- postgresDefault()
  print(dbListTables(db))
  dbDisconnect(db)
} else {
  message("No database connection.")
}
}
