% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rateHistory.R
\name{rateHistory}
\alias{rateHistory}
\title{Computing historical rates}
\usage{
rateHistory(RR)
}
\arguments{
\item{RR}{an object fitted by the function \code{\link{RRphylo}}.}
}
\value{
The function returns the vector of net historical rates
  (\code{$rateHistory$net.rate}) and the sum of rate modulus for each tip
  (\code{$rateHistory$norm.rate}), and the matrix of phenotypic changes
  from one node to the next along each lineage (\code{phen.path}).
}
\description{
The function calculates historical rates for each tip of the
  tree. Historical rates represent the sum of rates along subsequent branches
  of a lineage. The product of these rates multiplied by the relative branch
  lengths represents the phenotypic transformation from one node to the next
  one along the path. The function also provides the sum of rate modulus
  along lineages. This represents the total amount of evolutionary change per
  lineage.
}
\examples{
\dontrun{
data("DataCetaceans")
DataCetaceans$treecet->treecet
DataCetaceans$masscet->masscet
cc<- 2/parallel::detectCores()

RRphylo(tree=treecet,y=masscet,clus=cc)->RRcet

rateHistory(RR=RRcet)->rh

    }
}
\author{
Pasquale Raia, Silvia Castiglione
}
