% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deter_coefficient.R
\name{deter.coefficient}
\alias{deter.coefficient}
\title{Compute the determination cosfficient}
\usage{
deter.coefficient(ref, pred)
}
\arguments{
\item{ref}{Variable that was predicted.}

\item{pred}{The prediction given by the model.}
}
\value{
Return the determination cosfficient.
}
\description{
The determination coefficient represents a
goodness-of-fit measure commonly used in regression analysis to
capture the adjustment quality of a model.
}
\examples{
data(int_prost_test)
data(int_prost_train)
res.cm <- sym.lm(lpsa ~ ., sym.data = int_prost_train, method = "cm")
pred.cm <- sym.predict(res.cm, int_prost_test)
deter.coefficient(int_prost_test$lpsa, pred.cm$Fitted)
}
\references{
LIMA-NETO, E.A., DE CARVALHO, F.A.T., (2008). Centre and range method
to fitting a linear regression model on symbolic interval data. Computational
Statistics and Data Analysis 52, 1500-1515.

LIMA-NETO, E.A., DE CARVALHO, F.A.T., (2010). Constrained linear regression models
for symbolic interval-valued variables. Computational Statistics and
Data Analysis 54, 333-347.
}
\seealso{
sym.glm
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Elastic}
\keyword{Lasso}
\keyword{Net}
\keyword{Ridge}
\keyword{Symbolic}
