% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFSD.R
\name{afsd.test}
\alias{afsd.test}
\title{Compares prospects based on AFSD}
\usage{
afsd.test(sd.obj)
}
\arguments{
\item{sd.obj}{StochasticDominance object.}
}
\value{
A list, including all the calculation details.
}
\description{
It compares two prospects using AFSD criteria, that is the prospect having
the minimum violation area from a classic FSD.
}
\details{
The returned list has six elements: `winner` indicates the dominant prospect
index. It will be zero if neither dominates the other. `epsilon` is the ratio
of violated area to the total area between the CDFs. `area` is a vector, where
the values show the area between the CDFs correspond to each segment.
`total.area` is the total area between the CDFs. `positive.area` is the
amount of area where the `area` vector is positive, meaning the `cdf1` is
larger than `cdf2`. `negative.area` is like `positive.area` for negative
values.

If neither distribution dominates the other by AFSD, the `winner` output will
be zero, and it happens only when the expected value of distributions are
equal.

The `epsilon` and `winner` output parameters are the ones that should be
taken most. The others are the calculation details and are provided for
further investigation. A lower the `epsilon`, lower the violation ratio
of the dominant distribution, lower the eliminated extreme utilities, higher
the number of decision-makers who agree on the dominant distribution.
}
\examples{
sd = createStochasticDominance(outcome1 = c(1,4,7),
                               outcome2 = c(2,3,5),
                               prob1 = c(1/3,1/3,1/3),
                               prob2 = c(1/6,1/6,2/3))
afsd.test(sd)

}
\seealso{
[area.btwn.cdfs.calc()] for area calculations.
}
