% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{RSQL}
\alias{RSQL}
\alias{.onLoad}
\alias{RSQL-package}
\title{rsql}
\usage{
.onLoad(libname, pkgname)
}
\arguments{
\item{libname}{Library name}

\item{pkgname}{Package name}
}
\description{
A package to work with SQL datasources in a simple manner
}
\examples{
library(RSQL)
library(RSQLite)
db.name <- getMtcarsdbPath(copy = TRUE)
rsql <- createRSQL(drv = RSQLite::SQLite(), dbname = db.name)
select_sql <- rsql$gen_select(
  select_fields = "*", # c("wt", "qsec"),
  table = "mtcars",
  where_values = data.frame(carb = 8)
)
mtcars.observed <- rsql$execute_select(select_sql)
mtcars.observed

}
\author{
Alejandro Baranek <abaranek@dc.uba.ar>, Leonardo Javier Belen <leobelen@gmail.com>
Executes code while loading the package.
}
