% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{pstar.calc}
\alias{pstar.calc}
\title{Design prevalence back-calculation}
\usage{
pstar.calc(N = NA, n, sep, se)
}
\arguments{
\item{N}{populaton size if known (scalar or vector of same length as n)}

\item{n}{sample size (scalar or vector)}

\item{sep}{desired population sensitivity (scalar or vector of same length as n)}

\item{se}{unit sensitivity (scalar or vector of same length as n)}
}
\value{
vector of design prevalence values
}
\description{
Calculates design prevalence required for given sample size and
  desired population-level sensitivity, assuming
  imperfect test sensitivity, perfect test specificity and
  representative sampling
}
\examples{
# examples of pstar.calc- checked
pstar.calc(NA, 280, 0.95, 0.98)
pstar.calc(500, 250, sep=0.95, se=1)
pstar.calc(N=c(100, 500, 1000, 5000, 10000, 100000, NA), n=30, sep=0.95, se=1)
pstar.calc(500, n=30, sep=0.95, se=c(0.5, 0.6, 0.7, 0.8, 0.9, 0.99, 1))
}
\keyword{methods}
