% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2.R
\name{t2}
\alias{t2}
\alias{dt2}
\alias{pt2}
\alias{rt2}
\alias{qt2}
\alias{pt}
\title{Student t distribution with location and scale}
\usage{
dt2(x, mu, sigma, df, log = FALSE)

pt2(q, mu, sigma, df)

rt2(n, mu, sigma, df)

qt2(p, mu, sigma, df)

pt(q, df)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter}

\item{sigma}{scale parameter, must be positive.}

\item{df}{degrees of freedom, must be positive.}

\item{log}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{n}{number of random values to return.}

\item{p}{vector of probabilities}
}
\value{
\code{dt2} gives the density, \code{pt2} gives the distribution function, \code{qt2} gives the quantile function, and \code{rt2} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the t distribution with location and scale parameters.
}
\details{
This implementation of \code{dt2} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rt2(1, 1, 2, 5)
d <- dt2(x, 1, 2, 5)
p <- pt2(x, 1, 2, 5)
q <- qt2(p, 1, 2, 5)
}
