% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncnorm.R
\name{truncnorm}
\alias{truncnorm}
\alias{dtruncnorm}
\alias{ptruncnorm}
\alias{qtruncnorm}
\alias{rtruncnorm}
\title{Truncated normal distribution}
\usage{
dtruncnorm(x, mean = 0, sd = 1, min = -Inf, max = Inf, log = FALSE)

ptruncnorm(q, mean = 0, sd = 1, min = -Inf, max = Inf,
           lower.tail = TRUE, log.p = FALSE)

qtruncnorm(p, mean = 0, sd = 1, min = -Inf, max = Inf,
           lower.tail = TRUE, log.p = FALSE)

rtruncnorm(n, mean = 0, sd = 1, min = -Inf, max = Inf)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mean}{mean parameter, must be positive.}

\item{sd}{standard deviation parameter, must be positive.}

\item{min, max}{truncation bounds.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return.}
}
\value{
\code{dtruncnorm} gives the density, \code{ptruncnorm} gives the distribution function, \code{qtruncnorm} gives the quantile function, and \code{rtruncnorm} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the truncated normal distribution.
}
\details{
This implementation of \code{dtruncnorm} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rtruncnorm(1, mean = 2, sd = 2, min = -1, max = 5)
d <- dtruncnorm(x, mean = 2, sd = 2, min = -1, max = 5)
p <- ptruncnorm(x, mean = 2, sd = 2, min = -1, max = 5)
q <- qtruncnorm(p, mean = 2, sd = 2, min = -1, max = 5)
}
