% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinbinom2.R
\name{zinbinom2}
\alias{zinbinom2}
\alias{dzinbinom2}
\alias{pzinbinom2}
\alias{rzinbinom2}
\title{Zero-inflated and reparameterised negative binomial distribution}
\usage{
dzinbinom2(x, mu, size, zeroprob = 0, log = FALSE)

pzinbinom2(q, mu, size, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rzinbinom2(n, mu, size, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of (non-negative integer) quantiles}

\item{mu}{mean parameter, must be positive.}

\item{size}{size parameter, must be positive.}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}

\item{p}{vector of probabilities}
}
\value{
\code{dzinbinom2} gives the density, \code{pzinbinom2} gives the distribution function, and \code{rzinbinom2} generates random deviates.
}
\description{
Probability mass function, distribution function, quantile function and random generation for
the zero-inflated negative binomial distribution reparameterised in terms of mean and size.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzinbinom2(1, 2, 1, zeroprob = 0.5)
d <- dzinbinom2(x, 2, 1, zeroprob = 0.5)
p <- pzinbinom2(x, 2, 1, zeroprob = 0.5)
}
