% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_characters.R
\name{rx_punctuation}
\alias{rx_punctuation}
\title{Match punctuation characters.}
\usage{
rx_punctuation(.data = NULL, inverse = FALSE)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{ \%>\% }}

\item{inverse}{Invert match behavior, defaults to \code{FALSE} (match
punctuation). Use \code{TRUE} to \emph{not} match punctuation.}
}
\description{
Matches punctuation characters only:
\code{! \" # $ \% & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~}.
}
\examples{
rx_punctuation()
rx_punctuation(inverse = TRUE)

# create an expression
x <- rx_punctuation()

# create input
string <- 'Apple 1!'

# extract match
regmatches(string, gregexpr(x, string))

# dont extract punctuation
y <- rx_punctuation(inverse = TRUE)
regmatches(string, gregexpr(y, string))
}
