% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiers.R
\name{rx_with_any_case}
\alias{rx_with_any_case}
\title{Control case-insensitive matching.}
\usage{
rx_with_any_case(.data = NULL, enable = TRUE)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{ \%>\% }}

\item{enable}{Whether to enable this behavior}
}
\description{
Control case-insensitive matching.
}
\details{
Equivalent to adding or removing the i modifier.
}
\examples{
rx_with_any_case()

# case insensitive
x <- rx() \%>\%
  rx_find("abc") \%>\%
  rx_with_any_case()

# case sensitive
y <- rx() \%>\%
  rx_find("abc") \%>\%
  rx_with_any_case(enable = FALSE)

grepl(x, "ABC") # should be true
grepl(y, "ABC") # should be false
}
