% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearmon_helpers.R
\name{ym_get_wateryear}
\alias{ym_get_wateryear}
\alias{getWYFromYearmon}
\title{Get the water year from a year-month (yearmon) value}
\usage{
ym_get_wateryear(ym)

getWYFromYearmon(ym)
}
\arguments{
\item{ym}{An object of class \link[zoo:yearmon]{zoo::yearmon}, or something that can be
successfully converted to \link[zoo:yearmon]{zoo::yearmon}.}
}
\value{
The water year as a numeric.
}
\description{
\code{ym_get_wateryear()} returns the water year (assumed to be October -
September) from a \link[zoo:yearmon]{zoo::yearmon} object.
}
\details{
If the argument is not already a yearmon object, it will attempt to convert
it to a \link[zoo:yearmon]{zoo::yearmon}. This may result in unexpected results. For example,
the string \code{"12-1-1906"} can be converted to a \link[zoo:yearmon]{zoo::yearmon}, however, it
will not convert to \code{"Dec 1906"} as you might desire. It will convert to
\code{"Jan 0012"} since it is not a format expected by \code{\link[zoo:as.yearmon]{zoo::as.yearmon()}}.
Therefore, a warning is posted when the function attempts to convert to
\link[zoo:yearmon]{zoo::yearmon}, and it is safer to ensure \code{ym} is already a \link[zoo:yearmon]{zoo::yearmon}.
}
\examples{
ym_get_wateryear(zoo::as.yearmon(c("Dec 1906", "Oct 1945", "Jul 1955")))
ym_get_wateryear("2000-11")

}
