/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.util.regex.Pattern;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.RevisionUtils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.StreamableFilter;

public class RenameRelation
extends Filter
implements StreamableFilter,
WeightedAttributesHandler,
WeightedInstancesHandler {
    private static final long serialVersionUID = 8082179220141937043L;
    protected String m_relationNameModText = "change me";
    protected ModType m_modType = ModType.REPLACE;
    protected Pattern m_regexPattern;
    protected String m_regexMatch = "([\\s\\S]+)";
    protected boolean m_replaceAll;

    public String globalInfo() {
        return "A filter that allows the relation name of a set of instances to be altered.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @OptionMetadata(displayName="Text to use", description="The text to modify the relation name with", commandLineParamName="modify", commandLineParamSynopsis="-modify <string>", displayOrder=0)
    public void setModificationText(String text) {
        this.m_relationNameModText = text;
    }

    public String getModificationText() {
        return this.m_relationNameModText;
    }

    @OptionMetadata(displayName="Relation name modification type", description="The type of modification to apply (default = REPLACE)", commandLineParamName="mod-type", commandLineParamSynopsis="-mod-type <REPLACE | PREPEND | APPEND | REGEX>", displayOrder=1)
    public void setModType(ModType mod) {
        this.m_modType = mod;
    }

    public ModType getModType() {
        return this.m_modType;
    }

    @OptionMetadata(displayName="Regular expression", description="Regular expression to use for matching when performing a REGEX modification (default = ([\\s\\S]+))", commandLineParamName="find", commandLineParamSynopsis="-find <pattern>", displayOrder=2)
    public void setRegexMatch(String match) {
        this.m_regexMatch = match;
    }

    public String getRegexMatch() {
        return this.m_regexMatch;
    }

    @OptionMetadata(displayName="Replace all regex matches", description="Replace all matching occurrences if set to true, or just the first match if set to false", commandLineParamName="replace-all", commandLineParamSynopsis="-replace-all", commandLineParamIsFlag=true, displayOrder=3)
    public void setReplaceAll(boolean replaceAll) {
        this.m_replaceAll = replaceAll;
    }

    public boolean getReplaceAll() {
        return this.m_replaceAll;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        if (this.m_modType == ModType.REGEX && this.m_relationNameModText != null && this.m_relationNameModText.length() > 0 && this.m_regexMatch != null && this.m_regexMatch.length() > 0) {
            this.m_regexPattern = Pattern.compile(this.m_regexMatch);
        }
        this.applyRelationNameChange(this.outputFormatPeek());
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (instance.dataset() == null) {
            this.push((Instance)instance.copy());
        } else {
            this.push(instance);
        }
        return true;
    }

    protected void applyRelationNameChange(Instances insts) {
        switch (this.m_modType) {
            case REPLACE: {
                insts.setRelationName(this.m_relationNameModText);
                break;
            }
            case APPEND: {
                insts.setRelationName(this.getInputFormat().relationName() + this.m_relationNameModText);
                break;
            }
            case PREPEND: {
                insts.setRelationName(this.m_relationNameModText + this.getInputFormat().relationName());
                break;
            }
            case REGEX: {
                String rel = this.getInputFormat().relationName();
                rel = this.m_replaceAll ? this.m_regexPattern.matcher(rel).replaceAll(this.m_relationNameModText) : this.m_regexPattern.matcher(rel).replaceFirst(this.m_relationNameModText);
                insts.setRelationName(rel);
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: $");
    }

    public static void main(String[] argv) {
        RenameRelation.runFilter(new RenameRelation(), argv);
    }

    protected static enum ModType {
        REPLACE,
        PREPEND,
        APPEND,
        REGEX;

    }
}

