
#' All known two-letter place name abbreviations
#'
#' @noRd
#' @return Returns a matrix of known two-letter place name abbreviations
#'
acmacs_placeAbvs <- tibble::tribble(
  ~abv, ~placename,
  "-A", "SAUDI-ARABIA",
  "-B", "SUPHAN-BURI",
  "-D", "NORDRHEIN-WESTFALEN",
  "-G", "FRENCH-GUIANA",
  "-H", "SENDI-H",
  "-I", "RHODE-ISLAND",
  "-K", "SA-KAEO",
  "-L", "SRI-LANKA",
  "-M", "PUERTO-MONTT",
  "-N", "SAKON-NAKHON",
  "-O", "DISTRICT-OF-COLUMBIA",
  "-P", "ST-PETERSBURG",
  "-S", "SAN-SEBASTIAN",
  "-T", "SAN-ANTONIO",
  "-V", "MECKLENBURG-VORPO.",
  "AA", "ANNARBOR",
  "AB", "ALABAMA",
  "AC", "AICHI",
  "AD", "ALBANIA",
  "AE", "ALGERIA",
  "AF", "SOUTH-AFRICA",
  "AG", "ARGENTINA",
  "AH", "AUSTRIA",
  "AI", "ASTURIAS",
  "AJ", "SAKAI",
  "AK", "AKITA",
  "AL", "AUSTRALIA",
  "AM", "AMSTERDAM",
  "AN", "ANHUI",
  "AO", "AOMORI",
  "AP", "CHIANGMAI",
  "AQ", "ANG-THONG",
  "AR", "ARIZONA",
  "AS", "ALICESPRINGS",
  "AT", "ATLANTA",
  "AU", "AUCKLAND",
  "AV", "SANTIAGAO",
  "AX", "ALASKA",
  "AY", "AYTTHAYA",
  "AZ", "AYATTHAYA",
  "BA", "BANGKOK",
  "BB", "BILBAO",
  "BC", "BUCHAREST",
  "BD", "BADEN-WURTTEMBERG",
  "BE", "BEIJING",
  "BF", "BALEARES",
  "BG", "BELGIUM",
  "BH", "BELGRADE",
  "BI", "BILTHOVEN",
  "BJ", "BEIIJNG",
  "BK", "BANGKOKI",
  "BL", "BELEM",
  "BM", "BREMEN",
  "BN", "BERLIN",
  "BO", "BARCELONA",
  "BP", "BURIRUM",
  "BQ", "PATTANI",
  "BR", "BRISBANE",
  "BS", "BRASOV",
  "BT", "BAGKOK",
  "BU", "BUSAN",
  "BV", "PHARE",
  "BW", "PHICHIT",
  "BX", "BURIRAM",
  "BY", "BAYERN",
  "BZ", "BRAZIL",
  "CA", "CANBERRA",
  "CB", "CHIBA",
  "CC", "CHRISTCHURCH",
  "CD", "COLLINDALE",
  "CE", "CHEONNAM",
  "CF", "CALIFORNIA",
  "CG", "CHUNGNAM",
  "CH", "CHINA",
  "CI", "CAEN",
  "CJ", "CHEJU",
  "CK", "CHEONBUK",
  "CL", "CHILE",
  "CM", "CHIANGMAI",
  "CN", "CONNECTICUT",
  "CO", "COLORADO",
  "CP", "CLUJ",
  "CQ", "CANARIAS",
  "CR", "CHIANGRAI",
  "CS", "CALARASI",
  "CT", "CHITA",
  "CU", "CHANTABURI",
  "CV", "CARTAGENA",
  "CW", "CHANGWON",
  "CZ", "CZECHOSLOVAKIA",
  "DA", "DAEGU",
  "DB", "NY",
  "DC", "CA",
  "DD", "DUNDIN",
  "DE", "DELFT",
  "DF", "KYUNGGI",
  "DG", "PAU",
  "DH", "MILAN",
  "DI", "SALAMANCA",
  "DJ", "DAEJEON",
  "DK", "DAKAR",
  "DL", "CASABLANCA",
  "DM", "MEKNES",
  "DN", "DENMARK",
  "DO", "MARRAKECH",
  "DP", "AGADIR",
  "DQ", "ATHENS",
  "DR", "SANTANDER",
  "DS", "DESGENETTES",
  "DU", "DUNEDIN",
  "DV", "DEVA",
  "DW", "DARWIN",
  "DX", "TENNESEE",
  "DY", "BRANDYS",
  "DZ", "TRANG",
  "EA", "SIENA",
  "EB", "ANGTHONG",
  "EC", "ECUADOR",
  "ED", "NIEDERSACHSEN",
  "EE", "NEPAL",
  "EF", "KALASIN",
  "EG", "EGYPT",
  "EH", "EHIME",
  "EI", "EINDHOVEN",
  "EJ", "PHITSANULOK",
  "EK", "EKATERINBURG",
  "EL", "EL-SALVADOR",
  "EM", "PRACHUAPKHIRIKKAN",
  "EN", "ENGLAND",
  "EO", "CHACHOENGSAO",
  "EP", "NEW-HAMPSHIRE",
  "EQ", "EQUADOR",
  "ER", "TOMSK",
  "ES", "ENSCHEDE",
  "ET", "EXTREMAD",
  "EU", "EUSKADI",
  "EV", "PONTEVEORA",
  "EX", "EXTREMADURA",
  "EY", "KYOTO",
  "EZ", "EKATEZINBURG",
  "FA", "FATICK",
  "FB", "FUKUI",
  "FC", "FUKUOKA-C",
  "FD", "FES",
  "FE", "FIRENZE",
  "FF", "ANNECY",
  "FG", "MACU",
  "FH", "FOSHAN",
  "FI", "FINLAND",
  "FJ", "FIJI",
  "FK", "FUOKA",
  "FL", "FLORIDA",
  "FM", "SUKHBAATAR",
  "FN", "SAINSHAND",
  "FO", "FLORENCE",
  "FP", "CAMBODIA",
  "FQ", "HOLLAND",
  "FR", "FRANCE",
  "FS", "FUKUSHIMA",
  "FT", "DUBAI",
  "FU", "FUJIAN",
  "FV", "GANSUCHENGGUAN",
  "FW", "HONDURAS",
  "FX", "KALININGRAD",
  "FY", "ASTRAKHAN",
  "FZ", "FUZHOU",
  "GA", "GUAM",
  "GB", "GENOA",
  "GC", "GREECE",
  "GD", "GUANGDONG",
  "GE", "GENEVA",
  "GF", "GUILDFORD",
  "GG", "GEORGIA",
  "GH", "GIRONA",
  "GI", "GIFU",
  "GJ", "GUADALAJARA",
  "GK", "GOTEBURG",
  "GL", "GUALDALAGARA",
  "GM", "GUMMA",
  "GN", "GRANADA",
  "GO", "GOTENBORG",
  "GP", "GIFU-C",
  "GQ", "GALICIA",
  "GR", "GRONINGEN",
  "GS", "GANSU",
  "GT", "GOTEBORG",
  "GU", "GUIZHOU",
  "GV", "SEGOVIA",
  "GW", "GUNMA",
  "GX", "GUANGXI",
  "GY", "GERMANY",
  "GZ", "GUANGZHOU",
  "HA", "HAWAII",
  "HB", "HARBIN",
  "HC", "SACHSEN",
  "HD", "HOKKAIDO",
  "HE", "HEBEI",
  "HF", "HIROSHIMA",
  "HG", "HUNGARY",
  "HH", "SHIZUOKA",
  "HI", "HUBEI",
  "HJ", "HYOGO",
  "HK", "HONGKONG",
  "HL", "HIME",
  "HM", "HENAN",
  "HN", "HUNAN",
  "HO", "HOUSTON",
  "HP", "HONG-KONGK",
  "HQ", "HAINAN",
  "HS", "HIROSHIMA-C",
  "HT", "HAMAMATU-C",
  "HU", "HUNTINGTON",
  "HV", "HANNOVER",
  "HW", "NAKHON-SAWAN",
  "HX", "SHAANXI",
  "HY", "CHANTHABURI",
  "HZ", "SHIZUOKA-C",
  "IA", "IASI",
  "IB", "IBARAKI",
  "IC", "INCHEON",
  "ID", "INDONESIA",
  "IE", "ICELAND",
  "IF", "IRAN",
  "IH", "IDAHO",
  "II", "INDIA",
  "IJ", "BEIJINGXUANWU",
  "IK", "ISHIKAWA",
  "IL", "ILLINOIS",
  "IM", "SHIMANE",
  "IN", "INDIANA",
  "IO", "SOLOMON-ISLANDS",
  "IP", "MURMANSK",
  "IQ", "STPETERSBURG",
  "IR", "IRELAND",
  "IS", "ISRAEL",
  "IT", "ITALY",
  "IU", "ISTANBUL",
  "IV", "INVERNESS",
  "IW", "IWATE",
  "IX", "BEIJINXUANWU",
  "IY", "CHAIYAPUM",
  "IZ", "HAMBURG",
  "JA", "JIANGXI",
  "JB", "BRANDENBURG",
  "JC", "BURSA",
  "JD", "EDIRNE",
  "JE", "ANTALYA",
  "JF", "KHOVD",
  "JG", "NEWYORK",
  "JH", "JHB",
  "JI", "JILIN",
  "JJ", "JEJU",
  "JK", "NOVGOROD",
  "JL", "TURKEY",
  "JM", "SUDAN",
  "JN", "AFGHANISTAN",
  "JO", "JOHANNESBURG",
  "JP", "JAPAN",
  "JQ", "NIGERIA",
  "JR", "KENTUCKY",
  "JS", "JIANGSU",
  "JT", "TALCAHUANO",
  "JU", "UTAH",
  "JV", "MASSACHUSETTS",
  "JW", "KANSAS",
  "JX", "JIANGXIDONGHU",
  "JY", "MONTANA",
  "JZ", "IOWA",
  "KA", "KASAULI",
  "KB", "KAGAWA",
  "KC", "KOCHI",
  "KD", "KANAGAWA",
  "KE", "KUMAMOTO-C",
  "KF", "KUM",
  "KG", "KAGOSHIMA",
  "KH", "KHABAROVSK",
  "KI", "KYONGGI",
  "KJ", "KWANGJU",
  "KK", "KYONGBUK",
  "KL", "KHON-KAEN",
  "KM", "KUMAMOTO",
  "KN", "KANGWON",
  "KO", "KOBE",
  "KP", "NAKHON-PATHOM",
  "KQ", "KAMPHAENG-PHET",
  "KR", "KOREA",
  "KS", "KAWASAKI",
  "KT", "KYOTO-C",
  "KU", "KITAKYUSYU",
  "KV", "KANCHANABURI",
  "KW", "KWANGJIN",
  "KX", "KYUNGNAM",
  "KY", "KITAKYUSHU",
  "KZ", "KYONGNAM",
  "LA", "LAUSANNE",
  "LB", "LOPBURI",
  "LC", "LOP-BURI",
  "LD", "LYON-TRS",
  "LE", "LENINGRAD",
  "LF", "LOBBURI",
  "LG", "LIAONING",
  "LH", "LYON-CHU",
  "LI", "LINNKOPING",
  "LJ", "LAMPANG",
  "LK", "LAMOANG",
  "LL", "CASTILLA",
  "LM", "LIMOGES",
  "LN", "LEON",
  "LO", "LOSANGELES",
  "LP", "LIPETZK",
  "LQ", "LOEI",
  "LR", "LA-REUNION",
  "LS", "LISBON",
  "LT", "LATVIA",
  "LU", "LOUISIANA",
  "LV", "SLOVENIA",
  "LW", "SCHLESWIG-HOLSTEIN",
  "LX", "LEICESTERSHIRE",
  "LY", "LYON",
  "LZ", "LINCOLN",
  "MA", "MADRID",
  "MB", "MOROCCO",
  "MC", "MICHIGAN",
  "MD", "MAD",
  "ME", "MEMPHIS",
  "MF", "CLERMONTFERRAND",
  "MG", "MIYAGI",
  "MH", "MAE-HONG-SORN",
  "MI", "MISSISSIPPI",
  "MJ", "MIE",
  "MK", "MIYAZAKI",
  "ML", "MALY",
  "MM", "MALMO",
  "MN", "MAE-HONG-SON",
  "MO", "MISSOURI",
  "MP", "MONTPELLIER",
  "MQ", "MACAU",
  "MR", "MADAGASCAR",
  "MS", "MINNESOTA",
  "MT", "SAMUT-SAKHON",
  "MU", "SAMUT-PRAKAN",
  "MV", "MONGOLIA",
  "MW", "MOSCOW",
  "MX", "MEXICO",
  "MY", "MAYOCLINIC",
  "MZ", "MASSACHUSETS",
  "NA", "NANCHANG",
  "NB", "NEBRASKA",
  "NC", "NEWCASTLE",
  "ND", "NORTH-DAKOTA",
  "NE", "NICE",
  "NF", "NRW",
  "NG", "NIIGATA",
  "NH", "NARA",
  "NI", "NIJMEGEN",
  "NJ", "NEW-JERSEY",
  "NK", "NAGANO",
  "NL", "NETHERLANDS",
  "NM", "NAGOYA",
  "NN", "NINGBO",
  "NO", "NORTH-CAROLINA",
  "NP", "NIGATA",
  "NQ", "NAPAL",
  "NR", "NOVOSIBIRSK",
  "NS", "NAGASAKI",
  "NT", "NIIGATA-C",
  "NU", "NONTHABURI",
  "NV", "NEVADA",
  "NW", "NEW-CALEDONIA",
  "NX", "NINGXIA",
  "NY", "NEW-YORK",
  "NZ", "NAKHON-RATCHASIMA",
  "OA", "OSAKA-C",
  "OB", "NOVY-BYDZOV",
  "OC", "OTAGA",
  "OD", "NORDRHEIN",
  "OE", "ORENSE",
  "OF", "OREL",
  "OG", "OREGON",
  "OH", "OHIO",
  "OI", "OITA",
  "OJ", "BOLIVIA",
  "OK", "OKLAHOMA",
  "OL", "CHOIBALSAN",
  "OM", "OMSK",
  "ON", "OKINAWA",
  "OO", "NAKONNAYOK",
  "OP", "GUADELOUPE",
  "OQ", "CHONGQING",
  "OR", "ORADEA",
  "OS", "OSLO",
  "OT", "OTAGO",
  "OU", "OUJDA",
  "OV", "OVIEDO",
  "OW", "NORWAY",
  "OX", "MAINE",
  "OY", "OKAYAMA",
  "OZ", "RUSSIA",
  "PA", "PARIS",
  "PB", "PARMA",
  "PC", "PORT-CHALMERS",
  "PD", "POLAND",
  "PE", "PERTH",
  "PF", "PHATTHALUNG",
  "PG", "PERUGIA",
  "PH", "PHILIPPINES",
  "PI", "POITIERS",
  "PJ", "PRAJIANBURI",
  "PK", "PHUKET",
  "PL", "PILSEN",
  "PM", "PANAMA",
  "PN", "PUSAN",
  "PO", "PUERTO-RICO",
  "PP", "PRACHUAP-KHIRI-KHAN",
  "PQ", "PATHUMTHANI",
  "PR", "PRAGUE",
  "PS", "PENNSYLVANIA",
  "PT", "PATHUM-THANI",
  "PU", "PERU",
  "PV", "PHILLIPINES",
  "PW", "PRACHINBURI",
  "PX", "PHETCHABUN",
  "PY", "PARAGUAY",
  "PZ", "PRABCHINBURI",
  "QA", "QUANZHOU",
  "QB", "BANGLADESH",
  "QC", "CORDOBA",
  "QD", "ARKANSAS",
  "QE", "MARTINIQUE",
  "QF", "COLOMBIA",
  "QG", "JAMAICA",
  "QH", "POL",
  "QI", "KIEV",
  "QJ", "ODESSA",
  "QK", "PALENCIA",
  "QL", "NOUACKCHOTT",
  "QM", "HESSEN",
  "QN", "GERONA",
  "QO", "MAURITIUS",
  "QP", "FUKUOKAC",
  "QQ", "CONGQING",
  "QR", "GIFUC",
  "QS", "HIROSHIMAC",
  "QT", "QINGDAO",
  "QU", "QUEENSLAND",
  "QV", "KUMAMOTOC",
  "QW", "NIIGATAC",
  "QX", "SENDAIH",
  "QY", "MARSEILLE",
  "QZ", "BORDEAUX",
  "RA", "ROME",
  "RB", "ROI-ET",
  "RC", "PRACHINMURI",
  "RD", "ROTTERDAM",
  "RE", "REUNION",
  "RF", "RABAT",
  "RG", "ARAGON",
  "RH", "RHEINLAND-PFALZ",
  "RI", "SORIA",
  "RJ", "RIO-DE-JANEIRO",
  "RK", "SAMUTPRAKHAN",
  "RL", "BRATISLAVA",
  "RM", "ROMANIA",
  "RN", "SURIN",
  "RO", "ROMA",
  "RP", "PRACHUAPKHIRIKHAN",
  "RQ", "ROSTOV-ON-DON",
  "RR", "SARABURI",
  "RS", "BURGOS",
  "RT", "RATCHABURI",
  "RU", "RU",
  "RV", "ARVAIKHEER",
  "RW", "NARATHIWAT",
  "RX", "ROSTOVDON",
  "RY", "KRASNOYARSK",
  "RZ", "TRABZON",
  "SA", "SOUTH-AUSTRALIA",
  "SB", "SAGA",
  "SC", "SOUTH-CAROLINA",
  "SD", "SHANGDONG",
  "SE", "SENDAI",
  "SF", "SOFIA",
  "SG", "SHIGA",
  "SH", "SHANGHAI",
  "SI", "SICHUAN",
  "SJ", "SPAIN",
  "SK", "ST.-ETIENNE",
  "SL", "SCOTLAND",
  "SM", "SAMARA",
  "SN", "ST-ETIENNE",
  "SO", "SOUTH-DAKOTA",
  "SP", "SINGAPORE",
  "SQ", "SACHSEN-ANHALT",
  "SR", "SAPPORO",
  "SS", "ST.-PETERSBURG",
  "ST", "STOCKHOLM",
  "SU", "SEOUL",
  "SV", "SHANTOU",
  "SW", "SW",
  "SX", "SOPHIA",
  "SY", "SYDNEY",
  "SZ", "SANTIAGO",
  "TA", "TAIWAN",
  "TB", "THURINGEN",
  "TC", "TOCHIGI",
  "TD", "TRENTO",
  "TE", "TEXAS",
  "TF", "TARRAGONA",
  "TG", "TONGA",
  "TH", "THESSALONIKI",
  "TI", "TILBURG",
  "TJ", "TIANJIN",
  "TK", "TAK",
  "TL", "THAILAND",
  "TM", "TASMANIA",
  "TN", "TOULON",
  "TO", "TOULOUSE",
  "TP", "TOYAMA",
  "TQ", "TOKUSHIMA",
  "TR", "TEHRAN",
  "TS", "TRIESTE",
  "TT", "TOTTORI",
  "TU", "TULA",
  "TV", "TOWNSVILLE",
  "TW", "TENNESSEE",
  "TX", "TX",
  "TY", "TOKYO",
  "TZ", "TANGER",
  "UA", "U.K.",
  "UB", "UTTARADIT",
  "UC", "UD",
  "UD", "UDORN",
  "UE", "UBON-RATCHATHANI",
  "UF", "UBONRATCHATHANI",
  "UG", "URUAGUAY",
  "UH", "SUPHANBURI",
  "UI", "UNITED-KINGDOM",
  "UJ", "UTHAI-THANI",
  "UK", "UK",
  "UL", "ULSAN",
  "UM", "UMEA",
  "UN", "UNITEDKINGDOM",
  "UO", "SUKHOTHAI",
  "UP", "SAMUTPRAKAN",
  "UQ", "UMEA",
  "UR", "URUGUAY",
  "US", "USSR/RUSSIA",
  "UT", "UTRECHT",
  "UU", "ULAN-UDE",
  "UV", "SUCEAVA",
  "UW", "ULAANBAATAR",
  "UX", "BENELUX",
  "UY", "GUYANE",
  "UZ", "UKRAINE",
  "VA", "VALENCIA",
  "VB", "VINA-DEL-MAR",
  "VC", "COSTARICA",
  "VD", "VALLADOLID",
  "VE", "VIETNAM",
  "VF", "COOK-ISLAND",
  "VG", "VIRGINIA",
  "VH", "JEONBUK",
  "VI", "VICTORIA",
  "VJ", "GUATEMALA",
  "VK", "SLOVAKIA",
  "VL", "VOLGOGRAD",
  "VM", "VLADIMIR",
  "VN", "VIENNA",
  "VO", "VORONEZH",
  "VP", "KENYA",
  "VQ", "SING",
  "VR", "STAVROPOL",
  "VT", "VERMONT",
  "VV", "AVILA",
  "VY", "IVORY-COAST",
  "VZ", "VENEZUELA",
  "WA", "WASHINGTON",
  "WB", "WY--",
  "WE", "WELLINGTON",
  "WG", "GWANGJU",
  "WH", "WUZHOU",
  "WK", "WAIKATO",
  "WM", "WAKAYAMA",
  "WN", "WISCONSIN",
  "WO", "GANGWON",
  "WR", "WARSAW",
  "WS", "WEST-VIRGINIA",
  "WU", "WUHAN",
  "WV", "WESTVIRGINIA",
  "WW", "NEWMARKET",
  "WX", "NEW-MEXICO",
  "WY", "WYOMING",
  "WZ", "SWITZERLAND",
  "XI", "XINJIANGCHANGJI",
  "XJ", "XINJIANG-HUTUBI",
  "XM", "XIAMEN",
  "XN", "XINJIANGHUTUBI",
  "XX", "CX-ROUSSE",
  "YA", "YAMAGA",
  "YB", "YUNAN",
  "YD", "BYDGOSZCZ",
  "YE", "GYEONGNAM",
  "YG", "YAMAGUCHI",
  "YI", "YAMANESHI",
  "YK", "YOKOSUKA",
  "YL", "MARYLAND",
  "YM", "YAMANASHI",
  "YN", "KYUNGBUK",
  "YO", "YOKOHAMA",
  "YR", "YARYSLAVL",
  "YS", "YAROSLAVL",
  "YT", "YAMAGATA",
  "YU", "YUNNAN",
  "YY", "NAKHONNAYOK",
  "YZ", "YUNGNAM",
  "ZA", "ZAMBIA",
  "ZB", "AZERBAIJAN",
  "ZE", "ZAGREB",
  "ZG", "ZARAGOSSA",
  "ZH", "ZHEJIANG",
  "ZI", "IZMIR",
  "ZL", "ZLIN",
  "ZM", "ZAMORA",
  "ZN", "RYAZAN",
  "ZR", "ZARAGOZA",
  "ZU", "SHIZUOKAC",
  "ZX", "CHUNGBUK",
  "ZY", "SAITAMA",
  "OT", "GOETEBORG",
)

# Table of ambiguous names
ambig_places <- tibble::tribble(
  ~abv, ~placename,
  "vn", "vietnam",
  "hn", "hanoi"
)
