% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_stress.R
\name{logtiterTable}
\alias{logtiterTable}
\title{Get the log titers from an acmap}
\usage{
logtiterTable(map)
}
\arguments{
\item{map}{The acmap object}
}
\value{
Returns a matrix of titers converted to the log scale
}
\description{
Converts titers to the log scale via via the transformation
$log2(x/10)$, lessthan values are reduced by 1 on the log scale and greater
than values are increased by 1, hence <10 => -1 and >1280 => 8
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()},
\code{\link{unstableMaps}}

Other functions relating to map stress calculation: 
\code{\link{mapDistances}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()}
}
\concept{functions relating to map stress calculation}
\concept{map diagnostic functions}
