% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_merge.R
\name{mergeMaps}
\alias{mergeMaps}
\title{Merging maps}
\usage{
mergeMaps(
  ...,
  method = "table",
  number_of_dimensions,
  number_of_optimizations,
  minimum_column_basis = "none",
  optimizer_options = list(),
  merge_options = list(),
  verbose = TRUE
)
}
\arguments{
\item{...}{acmaps to merge provided as either a list, or a series of separate arguments}

\item{method}{The merge method to use, see details.}

\item{number_of_dimensions}{For merging that generates new optimization runs,
the number of dimensions.}

\item{number_of_optimizations}{For merging that generates new optimization
runs, the number of optimization runs to do.}

\item{minimum_column_basis}{For merging that generates new optimization runs,
the minimum column basis to use.}

\item{optimizer_options}{For merging that generates new optimization runs, optimizer
settings (see \code{RacOptimizer.options()}).}

\item{merge_options}{Options to use when merging titers (see \code{RacMerge.options()}).}

\item{verbose}{Should progress messages be output?}
}
\value{
Returns the merged map object
}
\description{
Functions to merge together two tables or maps.
}
\details{
Maps can be merged in a number of ways depending upon the desired
result.

\subsection{Method 'table'}{ As you would expect, this merges the tables of
the two maps but does not attempt to create any new optimizations and any
existing optimizations are lost. }

\subsection{Method 'reoptimized-merge'}{ This merges the tables and then
does a specified number of fresh optimizations from random starting
coordinates, ignoring any pre-existing optimization runs. It's exactly the
same as doing a 'table' merge and running \code{optimizeMap()} on the merged
table. }

\subsection{Method 'incremental-merge'}{ This takes the currently selected
optimization in the first map and then merges in the additional maps in
turn. Each time any points not already found in the first map (or the last
map in the incremental merge chain) are randomised and everything is
relaxed, this is repeated the specified number of times and the process is
repeated. }

\subsection{Method 'frozen-overlay'}{ This fixes the positions of points in
each map and tries to best match them simply through re-orientation. Once
the best re-orientation is found, points that are in common between the
maps are moved to the average position. }

\subsection{Method 'relaxed-overlay'}{ This is the same as the
frozen-overlay but points in the resulting map are then allowed to relax. }

\subsection{Method 'frozen-merge'}{ In this version, positions of all
points in the first map are fixed and remain fixed, so the original map
does not change. The second map is then realigned to the first as closely
as possible and then all the new points appearing in the second map are
allowed to relax into their new positions. This is a way to merge in new
antigens and sera into a map without affecting the first one at all (and
was first implemented in lisp). }
}
\seealso{
Other map merging functions: 
\code{\link{RacMerge.options}()},
\code{\link{htmlMergeReport}()},
\code{\link{mergeReport}()},
\code{\link{splitTiterLayers}()}
}
\concept{map merging functions}
